package kr.co.compcarecompany.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import kr.co.compcarecompany.R;

import static android.content.Context.INPUT_METHOD_SERVICE;

public class MachinePasswordDialog extends Dialog {

    private String mb_machine_pw;
    private TextView machine_pw_cancelTV, machine_pw_okTV;
    private EditText machine_pw_passwordET, dlg_pw1ET, dlg_pw2ET, dlg_pw3ET, dlg_pw4ET;

    private MachinePasswordDialogListener machinePasswordDialogListener;

    public MachinePasswordDialog(Context context, String mb_machine_pw, MachinePasswordDialogListener machinePasswordDialogListener) {
        super(context);
        this.machinePasswordDialogListener = machinePasswordDialogListener;
        this.mb_machine_pw = mb_machine_pw;
    }

    public interface MachinePasswordDialogListener {
        void clickBtn(boolean matched_pw);
    }

    @Override
    protected void onCreate(Bundle saveInstanceState) {
        super.onCreate(saveInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_machine_password);
        setCancelable(false);

        machine_pw_cancelTV = findViewById(R.id.machine_pw_cancelTV);
        machine_pw_okTV = findViewById(R.id.machine_pw_okTV);
        machine_pw_passwordET = findViewById(R.id.machine_pw_passwordET);

        dlg_pw1ET = findViewById(R.id.dlg_pw1ET);
        dlg_pw2ET = findViewById(R.id.dlg_pw2ET);
        dlg_pw3ET = findViewById(R.id.dlg_pw3ET);
        dlg_pw4ET = findViewById(R.id.dlg_pw4ET);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.8f);
        int y = (int) (size.y * 0.3f);

        thisWindow.setLayout(x, y);

        Set_Contents();
    }

    private void Set_Contents(){

        machine_pw_okTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                String pw1 = dlg_pw1ET.getText().toString();
                String pw2 = dlg_pw2ET.getText().toString();
                String pw3 = dlg_pw3ET.getText().toString();
                String pw4 = dlg_pw4ET.getText().toString();

                String pw = pw1+pw2+pw3+pw4;

                if(TextUtils.isEmpty(pw1) || TextUtils.isEmpty(pw2) || TextUtils.isEmpty(pw3) || TextUtils.isEmpty(pw4)){
                    Toast.makeText(getContext(), "숫자를 전부 입력해주세요.", Toast.LENGTH_SHORT).show();
                    return;
                }

                if(pw.equals(mb_machine_pw)){
                    machinePasswordDialogListener.clickBtn(true);
                    dismiss();

                } else {
                    Toast.makeText(getContext(), "비밀번호가 일치하지 않습니다.", Toast.LENGTH_SHORT).show();
                    dlg_pw1ET.getText().clear();
                    dlg_pw2ET.getText().clear();
                    dlg_pw3ET.getText().clear();
                    dlg_pw4ET.getText().clear();
                    dlg_pw1ET.requestFocus();
                }
            }
        });

        machine_pw_cancelTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                machinePasswordDialogListener.clickBtn(false);
                dismiss();
            }
        });

        dlg_pw1ET.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

                if(s.length() > 0){
                    dlg_pw2ET.requestFocus();
                }
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });

        dlg_pw2ET.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

                if(s.length() > 0){
                    dlg_pw3ET.requestFocus();
                }
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });

        dlg_pw3ET.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

                if(s.length() > 0){
                    dlg_pw4ET.requestFocus();
                }
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });

        dlg_pw4ET.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

                if(s.length() > 0){
                    InputMethodManager imm = (InputMethodManager) getContext().getSystemService(INPUT_METHOD_SERVICE);
                    imm.hideSoftInputFromWindow(getWindow().getCurrentFocus().getWindowToken(), 0);
                }
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });
    }
}
