package kr.co.compcarecompany.Util.CustomView;

import android.app.AlertDialog;
import android.content.Context;
import android.net.Uri;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.ortiz.touchview.TouchImageView;

import java.util.ArrayList;
import java.util.Objects;

import kr.co.compcarecompany.Data.FileDatum;
import kr.co.compcarecompany.R;

public class ServiceImageGridAdapter extends RecyclerView.Adapter<ServiceImageGridAdapter.ItemViewHolder> {

    ArrayList<FileDatum> items = new ArrayList<>();
    Context context;
    int itemHeight;

    public ServiceImageGridAdapter(Context context, int itemHeight) {
        this.context = context;
        this.itemHeight = itemHeight;
    }

    @NonNull
    @Override
    public ServiceImageGridAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {

        View view = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_report_image_grid, viewGroup, false);
        return new ServiceImageGridAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ServiceImageGridAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        itemViewHolder.serviceIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(context);
                AlertDialog dig = dialogBuilder.create();
                dig.getWindow().addFlags(WindowManager.LayoutParams.FLAG_BLUR_BEHIND);

                View view = LayoutInflater.from(context).inflate(R.layout.dlg_image, null);
                TouchImageView iv = view.findViewById(R.id.imageview);
                dig.setView(view);

                String manager_uri;
                if (items.get(position).getTableType().equals("work")) {
                    manager_uri = "https://www.compcare.co.kr/uploads/work/";

                } else {
                    manager_uri = "https://www.compcare.co.kr/uploads/alarm_report/";
                }

                String report_uri = items.get(position).getPfiFilename();

                Glide.with(Objects.requireNonNull(context)).load(Uri.parse(manager_uri + report_uri)).into(iv);
                dig.show();

                iv.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dig.dismiss();
                    }
                });
            }
        });
    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<FileDatum> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    public class ItemViewHolder extends RecyclerView.ViewHolder {

        ImageView serviceIV;
        LinearLayout serviceLL;

        public ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            serviceIV = itemView.findViewById(R.id.serviceIV);
            serviceLL = itemView.findViewById(R.id.serviceLL);
        }

        void onBind(FileDatum data) {
            itemView.getLayoutParams().height = itemHeight / 5;
            String manager_uri;
            if (data.getTableType() != null && data.getTableType().equals("work")) {
                manager_uri = "https://www.compcare.co.kr/uploads/work/";

            } else {
                manager_uri = "https://www.compcare.co.kr/uploads/alarm_report/";
            }
            String report_uri = data.getPfiFilename();
            Glide.with(Objects.requireNonNull(context)).load(manager_uri + report_uri).into(serviceIV);
        }
    }
}
