package kr.co.compcarecompany.Util;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;

import java.io.PrintWriter;
import java.io.StringWriter;

import kr.co.compcarecompany.Activity.ErrorActivity;
import kr.co.compcarecompany.R;

public class ExceptionHandler implements Thread.UncaughtExceptionHandler {

    private final Activity mContext;
    private final String LINE_SEPARATOR = "\n";

    public ExceptionHandler(Activity context){
        mContext = context;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        StringWriter stackTrace = new StringWriter();
        e.printStackTrace(new PrintWriter(stackTrace));
        StringBuilder errorReport = new StringBuilder();
        errorReport
                .append("***************** CAUSE OF ERROR *****************\n\n")
                .append(stackTrace.toString())
                .append("\n***************** DEVICE INFORMATION *****************\n")
                .append("Brand : ").append(Build.BRAND)
                .append(LINE_SEPARATOR)
                .append("Device : ").append(Build.DEVICE)
                .append(LINE_SEPARATOR)
                .append("Model : ").append(Build.MODEL)
                .append(LINE_SEPARATOR)
                .append("Id : ").append(Build.ID)
                .append(LINE_SEPARATOR)
                .append("Product : ").append(Build.PRODUCT)
                .append(LINE_SEPARATOR)
                .append("\n***************** FIRMWARE *****************\n")
                .append("SDK : ").append(Build.VERSION.SDK)
                .append(LINE_SEPARATOR)
                .append("Release : ").append(Build.VERSION.RELEASE)
                .append(LINE_SEPARATOR)
                .append("Incremental : ").append(Build.VERSION.INCREMENTAL)
                .append(LINE_SEPARATOR);

        AlertDialog.Builder dialog = new AlertDialog.Builder(mContext, AlertDialog.THEME_DEVICE_DEFAULT_LIGHT);
        dialog.setTitle(R.string.app_name);
        dialog.setMessage("오류가 발생하였습니다.");
        dialog.setPositiveButton("오류보기", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                Intent intent = new Intent(mContext, ErrorActivity.class);
                intent.putExtra("error", errorReport.toString());
                mContext.startActivity(intent);
                android.os.Process.killProcess(android.os.Process.myPid());
                System.exit(10);
                dialog.dismiss();
            }
        });

        dialog.setNegativeButton("종료하기", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                android.os.Process.killProcess(android.os.Process.myPid());
                System.exit(10);
                dialog.dismiss();
            }
        });
        dialog.show();
    }
}
