package kr.co.compcarecompany.Util.Service;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.ArrayItem;
import kr.co.compcarecompany.Data.Product.MonitoringData;

public class MonitoringThread extends Thread {
    private Handler handler;
    private boolean isRun = true;
    private String type, mac, air_line, k, i;
    private static int SLEEP = 2000;

    public MonitoringThread(Handler handler, String type, String mac) {
        this.handler = handler;
        this.type = type;
        this.mac = mac;
    }

    public MonitoringThread(Handler handler, String type, String mac, String i) {
        this.handler = handler;
        this.type = type;
        this.mac = mac;
        this.i = i;
    }

    public MonitoringThread(Handler handler, String type, String mac, String i, String k) {
        this.handler = handler;
        this.type = type;
        this.mac = mac;
        this.i = i;
        this.k = k;
    }

    public void stopForever() {
        synchronized (this) {
            this.isRun = false;
        }
    }

    public String getMac(){
        return mac;
    }

    public int getPosition(){
        return Integer.parseInt(i);
    }

    public void run() {
        //반복적으로 수행할 작업을 한다.
        while (isRun) {

            //쓰레드에 있는 핸들러에게 메세지를 보냄
            Message message = new Message();
            if(TextUtils.isEmpty(i)){
                message.obj = mac;
            } else {
                if(TextUtils.isEmpty(k)){
                    message.obj = mac+"i"+i;
                } else {
                    message.obj = mac+"i"+i+"k"+k;
                }
            }

            handler.sendMessage(message);
            if(Thread.interrupted()) {break;}
            if (type.equals("monitoring")) {

                try {
                    Thread.sleep(SLEEP);
                } catch (Exception e) {
                    e.printStackTrace();
                    break;
                }

            } else {
                stopForever();
            }
        }
    }
}
