package kr.co.compcarecompany.Activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import kr.co.compcarecompany.Data.ArrayItem;
import kr.co.compcarecompany.Data.ArrayItem_;
import kr.co.compcarecompany.Data.Company.CompanyData;
import kr.co.compcarecompany.Data.Memo.Login.UserItem;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;
import kr.co.compcarecompany.Util.ExceptionHandler;

public abstract class ActivityBasic extends AppCompatActivity {

    public Context context;
    public Handler handler;
    private int layout;
    private String title;

    ImageView back;
    TextView topTitle;

    public static ArrayItem_<UserItem> userItem;
    public static ArrayItem<CompanyData> companyItem;
    public static String cp_idx, mc_idx;


    public static int isSuccess = Activity.RESULT_CANCELED;

    protected abstract void init();

    protected abstract void init_Listener();

    protected abstract void getMessage(Message msg);

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(layout);
        context = this;

        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);

        init_Handler();
        init();
        init_Listener();
        init_default();
    }

    protected void setContentView(int layout, String title) {
        this.layout = layout;
        this.title = title;
    }


    private void init_default() {
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(this));
        if (!title.equals("인트로") && !title.equals("메인화면")) {
            back = findViewById(R.id.back);
            topTitle = findViewById(R.id.title);

            topTitle.setText(title);
            back.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    if (title.equals("거래명세표")) {
                        setResult(isSuccess);
                        finish();

                    } else if (title.equals("기계 옵션설정")) {

                        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(context);
                        dialogBuilder.setTitle("콤프케어 작업자");
                        dialogBuilder.setMessage("옵션 내역을 저장하지 않았습니다.\n메인으로 나가시겠습니까?");
                        dialogBuilder.setPositiveButton("팝업 창 닫기", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int i) {
                                dialog.dismiss();
                            }
                        });

                        dialogBuilder.setNeutralButton("나가기", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                                finish();
                            }
                        });
                        dialogBuilder.show();

                    } else if (title.equals("지점 관리")) {
                        Common.getInstance().toastShow(context, "지점 정보를 새롭게 불러옵니다...");
                        finish();

                    } else {
                        finish();
                    }
                }
            });
        }
    }

    @SuppressLint("HandlerLeak")
    protected void init_Handler() {
        handler = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 0) {
                    //Toast.makeText(context, msg.obj.toString(), Toast.LENGTH_LONG).show();
                    return;
                }
                getMessage(msg);
            }


        };
    }
}
