package kr.co.compcarecompany.Fragment.Main;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.ortiz.touchview.TouchImageView;

import java.util.Objects;

import kr.co.compcarecompany.Activity.FragmentActivity;
import kr.co.compcarecompany.R;

public class Help_Service_Fragment extends Fragment {

    private Handler handler;
    FragmentActivity fa;
    ImageView help1IV, help2IV, help3IV;
    ProgressBar helpPB;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        fa = (FragmentActivity) getActivity();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        fa = null;
    }

    @SuppressLint("ValidFragment")
    public Help_Service_Fragment(Handler handler) {
        this.handler = handler;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.frag_help_list, container, false);

        help1IV = v.findViewById(R.id.help1IV);
        help2IV = v.findViewById(R.id.help2IV);
        help3IV = v.findViewById(R.id.help3IV);
        helpPB = v.findViewById(R.id.helpPB);

        init_Listener();

        return v;
    }

    private void init_Listener() {

        //원격운전 변경
        help1IV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                helpPB.setVisibility(View.VISIBLE);

                AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(getContext());
                AlertDialog dig = dialogBuilder.create();
                dig.getWindow().addFlags(WindowManager.LayoutParams.FLAG_BLUR_BEHIND);

                View view = LayoutInflater.from(getContext()).inflate(R.layout.dlg_image, null);
                TouchImageView iv = view.findViewById(R.id.imageview);
                dig.setView(view);
                dig.setOnShowListener(new DialogInterface.OnShowListener() {
                    @Override
                    public void onShow(DialogInterface dialog) {
                        helpPB.setVisibility(View.GONE);
                    }
                });

                String help_uri = "https://www.compcare.co.kr/uploads/help/원격운전 변경법.jpg";
                Glide.with(Objects.requireNonNull(getContext())).load(Uri.parse(help_uri))
                        .diskCacheStrategy(DiskCacheStrategy.NONE)
                        .skipMemoryCache(true)
                        .into(iv);
                dig.show();

            }
        });

        //ESR 사용설명서
        help2IV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Intent target = new Intent(Intent.ACTION_VIEW);
                target.setDataAndType(Uri.parse("https://www.compcare.co.kr/uploads/help/ESR 사용 설명서.pdf"), "application/pdf");
                target.setFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);
                Intent intent = Intent.createChooser(target, "Open PDF using");
                try {
                    getContext().startActivity(intent);
                } catch (ActivityNotFoundException e) {
                    // Instruct the user to install a PDF reader here, or something
                    Toast.makeText(getContext(), "PDF 파일을 열 수 있는 어플이 없습니다", Toast.LENGTH_SHORT).show();
                }
            }
        });

        //App 사용설명서
        help3IV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Intent target = new Intent(Intent.ACTION_VIEW);
                target.setDataAndType(Uri.parse("https://www.compcare.co.kr/uploads/help/콤프케어 APP(공장용) 사용안내서.pdf"), "application/pdf");
                target.setFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);
                Intent intent = Intent.createChooser(target, "Open PDF using");
                try {
                    getContext().startActivity(intent);
                } catch (ActivityNotFoundException e) {
                    // Instruct the user to install a PDF reader here, or something
                    Toast.makeText(getContext(), "PDF 파일을 열 수 있는 어플이 없습니다", Toast.LENGTH_SHORT).show();
                }
            }
        });
    }
}
