package kr.co.compcarecompany.Util.Adapter;

import static kr.co.compcarecompany.Activity.ActivityBasic.userItem;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.github.mikephil.charting.charts.BarChart;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.data.PieEntry;
import com.github.mikephil.charting.formatter.PercentFormatter;
import com.squareup.picasso.Picasso;

import java.util.ArrayList;

import kr.co.compcarecompany.Activity.FragmentActivity;
import kr.co.compcarecompany.Data.ArrayItem;
import kr.co.compcarecompany.Data.FileDatum;
import kr.co.compcarecompany.Data.Product.MachineItem;
import kr.co.compcarecompany.Data.Product.MonitoringData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;
import kr.co.compcarecompany.Util.CustomSeekBar.CustomSeekBar;
import kr.co.compcarecompany.Util.CustomSeekBar.ProgressItem;
import kr.co.compcarecompany.Util.CustomView.AirLeakDialog;
import kr.co.compcarecompany.Util.CustomView.MachinePasswordDialog;
import kr.co.compcarecompany.Util.RoundedBarChart;

public class ContentAdapter extends RecyclerView.Adapter<ContentAdapter.ItemViewHolder> {

    Context context;
    private String mac;
    private ArrayList<MachineItem> items = new ArrayList<>();
    private ArrayItem<MonitoringData> monitoringArray;
    private boolean is_horizontal;

    //옵션버튼 클릭 리스너
    private ContentAdapter.clickListener clickListener;

    public interface clickListener {
        void option_clickBtn(Bundle bundle);

        void chart_clickBtn(Bundle bundle);

        void power_clickBtn(Bundle bundle);

        void iot_clickBtn(Bundle bundle);

        void schedule_clickBtn(Bundle bundle);

        void image_clickBtn(ArrayList<FileDatum> photo_data);

        void report_clickBtn(MachineItem item);

        void initial_clickBtn(String mc_iot_mac);

        void running_time_clickBtn(MachineItem item);
    }

    public ContentAdapter(Context context, boolean is_horizontal, ContentAdapter.clickListener clickListener) {
        setHasStableIds(true);
        this.context = context;
        this.is_horizontal = is_horizontal;
        this.clickListener = clickListener;
    }

    @NonNull
    @Override
    public ContentAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_content, viewGroup, false);
        return new ContentAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ContentAdapter.ItemViewHolder holder, @SuppressLint("RecyclerView") int position) {
        holder.onBind(items.get(position));

        if (is_horizontal) {
            holder.content_air_lineTV.setVisibility(View.VISIBLE);
            holder.contentLL.setBackgroundResource(R.drawable.bg_round_white_20);
        } else {

            if (position == 0 && !items.get(position).isLast_position()) {
                holder.contentLL.setBackgroundResource(R.drawable.bg_round_white_top_20);

            } else if (position == 0 && items.get(position).isLast_position()) {
                holder.contentLL.setBackgroundResource(R.drawable.bg_round_white_20);
            }
        }

        //iot 설치 버튼 클릭 리스너
        holder.content_mc_add_iotTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Bundle bundle = new Bundle();
                bundle.putString("mc_idx", items.get(position).getMcIdx());
                bundle.putString("pt_idx", items.get(position).getPtIdx());
                bundle.putString("cp_idx", items.get(position).getCpIdx());
                bundle.putString("mc_airline", items.get(position).getMcAirline());
                clickListener.iot_clickBtn(bundle);
            }
        });

        //옵션 버튼 클릭시
        holder.content_optionLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Bundle bundle = new Bundle();
                bundle.putString("mc_idx", items.get(position).getMcIdx());
                bundle.putString("pt_idx", items.get(position).getPdIdx());
                bundle.putString("cp_idx", items.get(position).getCpIdx());
                bundle.putString("mac", items.get(position).getMcIotMac());

                if (items.get(position).getMonitoring() == null) {
                    bundle.putString("return", "true");
                } else {
                    bundle.putString("return", "false");
                }

                // 23.08.05
          /*
                if (items.get(position).getMonitoring() != null && items.get(position).getMonitoring().get(0).getInverterError() != null && items.get(position).getMonitoring().get(0).getInverterError().equals("1")) {
                    bundle.putString("inverter_error", "true");
                }

                if (items.get(position).getMonitoring() != null && items.get(position).getMonitoring().get(0).getPowerError() != null && items.get(position).getMonitoring().get(0).getPowerError().equals("1")) {
                    bundle.putString("power_error", "true");
                }
            */
                clickListener.option_clickBtn(bundle);
            }
        });

        // ON/Off 버튼 클릭 리스너
        holder.content_mc_powerIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (items.get(position).getMonitoring() == null) {
                    Bundle return_bundle = new Bundle();
                    return_bundle.putString("return", "true");
                    clickListener.power_clickBtn(return_bundle);
                    return;
                }

                // 23-03-27 인버터, 파워 error 시 on/off disable 해제 요청하심
                /*
                if (items.get(position).getMonitoring() != null && items.get(position).getMonitoring().get(0).getInverterError() != null
                        && Integer.parseInt(items.get(position).getMonitoring().get(0).getInverterError()) > 0) {
                    Bundle return_bundle = new Bundle();
                    return_bundle.putString("inverter_error", "true");
                    clickListener.power_clickBtn(return_bundle);
                    return;
                }

                if (items.get(position).getMonitoring() != null && items.get(position).getMonitoring().get(0).getPowerError() != null
                        && Integer.parseInt(items.get(position).getMonitoring().get(0).getPowerError()) > 0) {
                    Bundle return_bundle = new Bundle();
                    return_bundle.putString("power_error", "true");
                    clickListener.power_clickBtn(return_bundle);
                    return;
                }
                */

                //기계보안 비밀번호가 없을 경우 비밀번호 설정 페이지로 넘어감 //2021.04.05 수정
                if (userItem.getArrayitem().getPartner().getPtMachinePw() == null || userItem.getArrayitem().getPartner().getPtMachinePw().equals("")) {

                    AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(context);
                    dialogBuilder.setTitle("콤프케어 작업자");
                    dialogBuilder.setMessage("설정된 기계보안 비밀번호가 없습니다.\n바로 설정하시겠습니까?");
                    dialogBuilder.setPositiveButton("확인", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int i) {

                            Intent intent = new Intent(context, FragmentActivity.class);
                            intent.putExtra("title", "기계보안");
                            intent.putExtra("type", "password_setting");
                            intent.putExtra("value1", userItem.getArrayitem().getPartner().getPtMachinePw());
                            context.startActivity(intent);
                            dialog.dismiss();
                        }
                    });
                    dialogBuilder.setNegativeButton("취소", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    });
                    dialogBuilder.show();

                } else {

                    //기계 비밀번호 확인 다이얼로그
                    MachinePasswordDialog dialog = new MachinePasswordDialog(context, userItem.getArrayitem().getPartner().getPtMachinePw(), new MachinePasswordDialog.MachinePasswordDialogListener() {
                        @Override
                        public void clickBtn(boolean matched_pw) {

                            //비밀번호가 일치했을 경우
                            if (matched_pw) {
                                //mac이 있을 경우 //2021.04.05 수정
                                if (!TextUtils.isEmpty(items.get(position).getMcIotMac()) && items.get(position).getMcIotMac() != null) {

                                    String del_flag;

                                    if (items.get(position).getDelFlag().equals("MM")) {
                                        del_flag = "STOP";
                                        items.get(position).setSelected(false);
                                        holder.content_chartLL.setVisibility(View.VISIBLE);
                                    } else {
                                        del_flag = "MM";
                                        items.get(position).setSelected(true);
                                        holder.content_chartLL.setVisibility(View.VISIBLE);
                                    }

                                    Bundle bundle = new Bundle();
                                    bundle.putString("pt_idx", items.get(position).getPtIdx());
                                    bundle.putString("cp_idx", items.get(position).getCpIdx());
                                    bundle.putString("mc_idx", items.get(position).getMcIdx());
                                    bundle.putString("mac", items.get(position).getMcIotMac());
                                    bundle.putString("del_flag", del_flag);
                                    bundle.putString("position", position + "");

                                    clickListener.power_clickBtn(bundle);
                                }
                            }
                        }
                    });
                    dialog.show();

                }
            }
        });


        //스케줄 운전 버튼 리스터
        holder.machine_scheduleLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Bundle bundle = new Bundle();
                bundle.putString("mc_idx", items.get(position).getMcIdx());
                bundle.putString("mc_iot_mac", items.get(position).getMcIotMac());
                bundle.putString("mc_schedule_yn", items.get(position).getMcScheduleYn());

                if (items.get(position).getMonitoring() == null) {
                    bundle.putString("return", "true");
                } else {
                    bundle.putString("return", "false");
                }
            /*
                if (items.get(position).getMonitoring() != null && items.get(position).getMonitoring().get(0).getInverterError() != null
                        && items.get(position).getMonitoring().get(0).getInverterError().equals("1")) {
                    bundle.putString("inverter_error", "true");
                }

                if (items.get(position).getMonitoring() != null && items.get(position).getMonitoring().get(0).getPowerError() != null
                        && items.get(position).getMonitoring().get(0).getPowerError().equals("1")) {
                    bundle.putString("power_error", "true");
                }
           */
                clickListener.schedule_clickBtn(bundle);
            }
        });

        //차트 터치 리스너 >> EnterpriseRecyclerAdapter로 전달되어 상세페이지 팝업을 띄운다
        View.OnTouchListener touch = new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {

                String pop_type = "";

                if (event.getAction() == MotionEvent.ACTION_UP) {

                    if (v == holder.temperature1PC) {
                        pop_type = "temperatureNtc";
                    } else if (v == holder.temperature3PC) {
                        pop_type = "temperatureNtc2";
                    } else if (v == holder.temperature2PC) {
                        pop_type = "temperaturePt";
                    } else if (v == holder.pressure1PC) {
                        pop_type = "pressure1";
                    } else if (v == holder.pressure2PC) {
                        pop_type = "pressure2";
                    } else if (v == holder.pressure3PC) {
                        pop_type = "pressure3";
                    }

                    Bundle bundle = new Bundle();
                    bundle.putString("mc_idx", items.get(position).getMcIdx());
                    bundle.putString("pt_idx", items.get(position).getPtIdx());
                    bundle.putString("cp_idx", items.get(position).getCpIdx());
                    bundle.putString("mac", items.get(position).getMcIotMac());
                    bundle.putString("chart_type", pop_type);

                    clickListener.chart_clickBtn(bundle);
                    return true;

                } else {
                    return false;
                }
            }
        };

        //차트 터치 리스너와 동일 동작을 한다
        View.OnClickListener click = new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                String pop_type = "";

                if (v == holder.current1LL) {
                    pop_type = "current1";
                } else if (v == holder.current2LL) {
                    pop_type = "current2";
                } else if (v == holder.current3LL) {
                    pop_type = "current3";
                } else if (v == holder.power_consumptionLL) {
                    pop_type = "power_consumption";
                }

                Bundle bundle = new Bundle();
                bundle.putString("mc_idx", items.get(position).getMcIdx());
                bundle.putString("pt_idx", items.get(position).getPtIdx());
                bundle.putString("cp_idx", items.get(position).getCpIdx());
                bundle.putString("mac", items.get(position).getMcIotMac());
                bundle.putString("chart_type", pop_type);

                clickListener.chart_clickBtn(bundle);
            }
        };

        holder.air_leakLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AirLeakDialog dialog = new AirLeakDialog(context, items.get(position).getCpIdx(), items.get(position).getMcIdx());
                dialog.show();
            }
        });

        //이미지 클릭 리스너
        holder.content_mc_photoIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    clickListener.image_clickBtn(items.get(position).getMachinePhoto());
                } catch (Exception ignored) {
                }
            }
        });

        //레포트 클릭 리스너
        holder.monitor_reportLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                clickListener.report_clickBtn(items.get(position));
            }
        });

        //초기화 클릭 리스너
        holder.main_chart_InitializationLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clickListener.initial_clickBtn(items.get(position).getMcIotMac());
            }
        });

        //소모품시간 클릭 리스너
        holder.content_mc_runningLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clickListener.running_time_clickBtn(items.get(position));
            }
        });

        holder.current1LL.setOnClickListener(click);
        holder.current2LL.setOnClickListener(click);
        holder.current3LL.setOnClickListener(click);
        holder.power_consumptionLL.setOnClickListener(click);

        holder.pressure1PC.setOnTouchListener(touch);
        holder.pressure2PC.setOnTouchListener(touch);
        holder.pressure3PC.setOnTouchListener(touch);
        holder.temperature1PC.setOnTouchListener(touch);
        holder.temperature2PC.setOnTouchListener(touch);
        holder.temperature3PC.setOnTouchListener(touch);

    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<MachineItem> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    class ItemViewHolder extends RecyclerView.ViewHolder {

        LinearLayout content_mcLL, content_mc_qrLL, content_chart_liveLL, content_mc_runningLL, content_chartLL,
                current1LL, current2LL, current3LL, contentLL, content_optionLL, machine_scheduleLL, content_lotLL, power_consumptionLL, monitor_reportLL, main_chart_InitializationLL;

        TextView content_air_lineTV, content_none_lineTV, content_mc_indexTV, content_mc_typeTV, content_mc_qrTV, content_mc_nameTV, content_chart_liveTV,
                content_mc_stateTV, content_mc_running_minTV, content_mc_running_maxTV, current1_valueTV, current2_valueTV,
                current3_valueTV, current1_nameTV, current2_nameTV, current3_nameTV, pressure1_nameTV, pressure2_nameTV, pressure3_nameTV, temperature1_maxTV,
                temperature2_maxTV, temperature3_maxTV, content_none_iotTV, content_kwTV, machine_onTV, machine_offTV, remain_timeTV, content_mc_add_iotTV,
                machine_scheduleTV, content_mc_lotTV, content_exchange_dtTV, content_mc_inverter_modeTV, power_consumption_valueTV, cross_timeTV;

        ImageView content_chart_liveIV, content_optionIV, content_liveIV, machine_scheduleIV, content_mc_powerIV, content_mc_photoIV;
        BarChart current1BC, current2BC, current3BC, power_consumptionBC;
        PieChart pressure1PC, pressure2PC, pressure3PC, temperature1PC, temperature2PC, temperature3PC;

        ProgressBar content_mc_runningPB, content_chartPB, air_leakPB;
        View itemView;

        CustomSeekBar content_air_leakSB;

        LinearLayout air_leakLL;
        TextView air_leak_valueTV;

        private float totalSpan;
        private float redSpan;
        private float greenSpan;

        private ArrayList<ProgressItem> progressItemList;
        private ProgressItem mProgressItem;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            this.itemView = itemView;
            content_mcLL = itemView.findViewById(R.id.content_mcLL);
            content_mc_qrLL = itemView.findViewById(R.id.content_mc_qrLL);
            content_chart_liveLL = itemView.findViewById(R.id.content_chart_liveLL);
            content_mc_runningLL = itemView.findViewById(R.id.content_mc_runningLL);
            content_chartLL = itemView.findViewById(R.id.content_chartLL);
            current1LL = itemView.findViewById(R.id.current1LL);
            current2LL = itemView.findViewById(R.id.current2LL);
            current3LL = itemView.findViewById(R.id.current3LL);

            content_optionLL = itemView.findViewById(R.id.content_optionLL);

            content_none_iotTV = itemView.findViewById(R.id.content_none_iotTV);
            content_air_lineTV = itemView.findViewById(R.id.content_air_lineTV);
            content_none_lineTV = itemView.findViewById(R.id.content_none_lineTV);
            content_mc_indexTV = itemView.findViewById(R.id.content_mc_indexTV);
            content_mc_typeTV = itemView.findViewById(R.id.content_mc_typeTV);
            content_mc_qrTV = itemView.findViewById(R.id.content_mc_qrTV);
            content_mc_nameTV = itemView.findViewById(R.id.content_mc_nameTV);
            content_mc_stateTV = itemView.findViewById(R.id.content_mc_stateTV);
            content_mc_running_minTV = itemView.findViewById(R.id.content_mc_running_minTV);
            content_mc_running_maxTV = itemView.findViewById(R.id.content_mc_running_maxTV);
            current1_valueTV = itemView.findViewById(R.id.current1_valueTV);
            current2_valueTV = itemView.findViewById(R.id.current2_valueTV);
            current3_valueTV = itemView.findViewById(R.id.current3_valueTV);
            current1_nameTV = itemView.findViewById(R.id.current1_nameTV);
            current2_nameTV = itemView.findViewById(R.id.current2_nameTV);
            current3_nameTV = itemView.findViewById(R.id.current3_nameTV);
            pressure1_nameTV = itemView.findViewById(R.id.pressure1_nameTV);
            pressure2_nameTV = itemView.findViewById(R.id.pressure2_nameTV);
            pressure3_nameTV = itemView.findViewById(R.id.pressure3_nameTV);
            temperature1_maxTV = itemView.findViewById(R.id.temperature1_maxTV);
            temperature2_maxTV = itemView.findViewById(R.id.temperature2_maxTV);
            temperature3_maxTV = itemView.findViewById(R.id.temperature3_maxTV);

            content_chart_liveIV = itemView.findViewById(R.id.content_chart_liveIV);
            content_optionIV = itemView.findViewById(R.id.content_optionIV);
            content_mc_add_iotTV = itemView.findViewById(R.id.content_mc_add_iotTV);

            current1BC = itemView.findViewById(R.id.current1BC);
            current2BC = itemView.findViewById(R.id.current2BC);
            current3BC = itemView.findViewById(R.id.current3BC);
            pressure1PC = itemView.findViewById(R.id.pressure1PC);
            pressure2PC = itemView.findViewById(R.id.pressure2PC);
            pressure3PC = itemView.findViewById(R.id.pressure3PC);
            temperature1PC = itemView.findViewById(R.id.temperature1PC);
            temperature2PC = itemView.findViewById(R.id.temperature2PC);
            temperature3PC = itemView.findViewById(R.id.temperature3PC);

            content_mc_runningPB = itemView.findViewById(R.id.content_mc_runningPB);
            content_chartPB = itemView.findViewById(R.id.content_chartPB);

            contentLL = itemView.findViewById(R.id.contentLL);
            content_kwTV = itemView.findViewById(R.id.content_kwTV);

            remain_timeTV = itemView.findViewById(R.id.remain_timeTV);
            content_liveIV = itemView.findViewById(R.id.content_liveIV);

            machine_scheduleTV = itemView.findViewById(R.id.machine_scheduleTV);
            machine_scheduleLL = itemView.findViewById(R.id.machine_scheduleLL);
            machine_scheduleIV = itemView.findViewById(R.id.machine_scheduleIV);

            content_mc_powerIV = itemView.findViewById(R.id.content_mc_powerIV);

            content_lotLL = itemView.findViewById(R.id.content_lotLL);
            content_mc_photoIV = itemView.findViewById(R.id.content_mc_photoIV);

            content_mc_inverter_modeTV = itemView.findViewById(R.id.content_mc_inverter_modeTV);

            power_consumption_valueTV = itemView.findViewById(R.id.power_consumption_valueTV);
            power_consumptionBC = itemView.findViewById(R.id.power_consumptionBC);
            power_consumptionLL = itemView.findViewById(R.id.power_consumptionLL);
            monitor_reportLL = itemView.findViewById(R.id.monitor_reportLL);

            main_chart_InitializationLL = itemView.findViewById(R.id.main_chart_InitializationLL);

//            content_air_leakSB = itemView.findViewById(R.id.content_air_leakSB);
            air_leakPB = itemView.findViewById(R.id.air_leakPB);
            air_leakLL = itemView.findViewById(R.id.air_leakLL);
            air_leak_valueTV = itemView.findViewById(R.id.air_leak_valueTV);

            //교번제어 남은시간
            cross_timeTV = itemView.findViewById(R.id.cross_timeTV);
        }

        void onBind(MachineItem data) {

            content_mc_indexTV.setText(data.getIndex() + ". ");

            //등록된 에어라인이 없을경우 > 기계도 없다는 의미이기 때문에 리턴해줌
            if (data.getMcAirline() == null) {
                content_none_lineTV.setVisibility(View.VISIBLE);
                content_air_lineTV.setVisibility(View.GONE);
                return;
            }

            content_air_lineTV.setText("# " + data.getMcAirline());

            //실시간 차트 데이터 초기화
            if (data.getMonitoring() != null) {
                monitoringArray = data.getMonitoring();
                //2021.08.11 iot 아이콘 깜빡이지 않는 걸로 변경해달라하심
                content_liveIV.setImageResource(R.drawable.icon_iot);

            } else {
                monitoringArray = null;
                content_liveIV.setImageResource(R.drawable.icon_iot_stop);
            }

            Animation animation = new AlphaAnimation(1, 0);
            animation.setDuration(1500);
            animation.setInterpolator(new LinearInterpolator());
            animation.setRepeatCount(Animation.INFINITE);
            animation.setRepeatMode(Animation.RESTART);

            if (data.getMcScheduleYn().equals("Y")) {
                machine_scheduleIV.setImageResource(R.drawable.icon_power_green);
                machine_scheduleIV.startAnimation(animation);

            } else {
                machine_scheduleIV.setImageResource(R.drawable.icon_power_red);
            }

            get_MonitoringArray(data);

            if (data.getMachinePhotoCnt() != null && !data.getMachinePhotoCnt().equals("0")) {
                content_mc_photoIV.setVisibility(View.VISIBLE);
                content_mc_photoIV.setScaleType(ImageView.ScaleType.CENTER_CROP);
                content_mc_photoIV.setEnabled(true);

                String machine_uri = "https://www.compcare.co.kr/uploads/machine/" + data.getMachinePhoto().get(0).getPfiFilename();
                try {
                    Picasso picasso = new Picasso.Builder(context).listener(new Picasso.Listener() {
                        @Override
                        public void onImageLoadFailed(Picasso picasso, Uri uri, Exception exception) {
                            content_mc_photoIV.setImageResource(R.drawable.no_img);
                        }
                    }).build();

                    picasso.with(context).load(machine_uri).into(content_mc_photoIV);
                } catch (Exception e) {
                    content_mc_photoIV.setImageResource(R.drawable.no_img);
                }
            }

            //mac이 있을 경우 > LIVE 버튼, 옵션버튼 보임
            if (data.getMcIotMac() != null) {
                mac = data.getMcIotMac();
                content_none_iotTV.setVisibility(View.GONE);
                content_chart_liveLL.setVisibility(View.VISIBLE);
                content_mc_runningLL.setVisibility(View.VISIBLE);
                monitor_reportLL.setVisibility(View.VISIBLE);

                if (data.getMcInitializationYn().equals("N")) {
                    main_chart_InitializationLL.setVisibility(View.VISIBLE);
                    content_chartLL.setVisibility(View.GONE);
                    content_optionLL.setVisibility(View.GONE);
                } else {
                    content_chartLL.setVisibility(View.VISIBLE);
                    main_chart_InitializationLL.setVisibility(View.GONE);
                    content_optionLL.setVisibility(View.VISIBLE);
                }

                if (data.getMcRemoteYn() != null && data.getMcRemoteYn().equals("Y")) {
                    content_mc_powerIV.setVisibility(View.VISIBLE);
                    machine_scheduleLL.setVisibility(View.VISIBLE);

                } else {
                    content_mc_powerIV.setVisibility(View.GONE);
                    machine_scheduleLL.setVisibility(View.GONE);
                }

                if (data.getMcInverterYn().equals("N")) {
                    content_mc_inverter_modeTV.setText("Y-D");
                } else {
                    content_mc_inverter_modeTV.setText("INVERTER");
                }

                //에어리크
//                if (data.getMcAirLeakYn().equals("Y")) {
//                    air_leakLL.setVisibility(View.GONE);
//
//                    totalSpan = Float.parseFloat(data.getMcPressure1Max());
//                    float range = Float.parseFloat(data.getMcAirLeakRange());
//                    float air_leak_std = Float.parseFloat(data.getMcAirLeakStd());
//                    float air_leak = Float.parseFloat(Common.getInstance().isNullToZero(data.getMcAirLeakValue()));
//                    greenSpan = totalSpan - range - air_leak_std;
//                    redSpan = totalSpan - greenSpan;
//
//                    if (air_leak < (air_leak_std - range)) {
//                        air_leak_valueTV.setText("에어리크 발생 : "+air_leak+" Bar");
//                        air_leak_valueTV.setTextColor(context.getResources().getColor(R.color.red));
//                    } else if (air_leak == 0){
//                        air_leak_valueTV.setText("에어리크 측정 데이터 없음");
//                        air_leak_valueTV.setTextColor(context.getResources().getColor(R.color.gray));
//                    } else {
//                        air_leak_valueTV.setText("에어리크 정상 : "+air_leak+" Bar");
//                        air_leak_valueTV.setTextColor(context.getResources().getColor(R.color.pie_chart_green));
//                    }
//
//                    ProgressDrawable bgProgress = new ProgressDrawable(0, (int) (redSpan * 1000));
//                    air_leakPB.setProgressDrawable(bgProgress);
//                    bgProgress.setLevel((int) (air_leak) * 1000);
//                }

            } else {
                content_none_iotTV.setVisibility(View.VISIBLE);
                content_none_iotTV.setText("IoT가 설치되지 않았습니다");
                content_chartLL.setVisibility(View.GONE);
                content_chart_liveLL.setVisibility(View.GONE);
                content_mc_runningLL.setVisibility(View.GONE);
                content_mc_powerIV.setVisibility(View.GONE);
                machine_scheduleLL.setVisibility(View.GONE);
                monitor_reportLL.setVisibility(View.GONE);
            }

            if (data.getProductData().getPdTtypeStr().isEmpty() || data.getProductData().getPdTtypeStr() == null) {
                content_mc_typeTV.setText(data.getProductData().getPdTtype());
            } else {
                content_mc_typeTV.setText(data.getProductData().getPdTtypeStr());
            }
            content_mc_nameTV.setText(data.getProductData().getPdName());

            //qr 코드가 있으면 qr을 표시한다.

            if (data.getQrCode() != null) {
                content_mc_qrTV.setText(data.getQrCode().toString());
                content_mc_qrTV.setVisibility(View.VISIBLE);
                content_mc_add_iotTV.setVisibility(View.GONE);

            } else {
                content_mc_qrTV.setText("NO QR CODE");
                content_mc_add_iotTV.setVisibility(View.VISIBLE);
            }

            int runningTime = Integer.parseInt(Common.getInstance().isNullToZero(data.getMcRunningtime()));

            if (monitoringArray != null && monitoringArray.get(0).getInverterError() != null && Integer.parseInt(monitoringArray.get(0).getInverterError()) > 0) {

                content_mc_stateTV.setText("[인버터 이상감지]");
                content_mc_stateTV.setTextColor(Color.parseColor("#D71010"));
                remain_timeTV.setText(runningTime + "시간 사용함");
                remain_timeTV.setTextColor(context.getResources().getColor(R.color.gray));
                content_chart_liveIV.setImageResource(R.drawable.icon_play_red);
                content_kwTV.setTextColor(context.getResources().getColor(R.color.gray));
                content_mc_inverter_modeTV.setTextColor(Color.parseColor("#D71010"));

            } else if (monitoringArray != null && monitoringArray.get(0).getPowerError() != null && Integer.parseInt(monitoringArray.get(0).getPowerError()) > 0) {
                // 23.08.06 기계이상감지 -> 비상정지
                content_mc_stateTV.setText("기계 비상정지 권장(" + monitoringArray.get(0).getPowerError() + "Lv)");
                content_mc_stateTV.setTextColor(Color.parseColor("#D71010"));
                remain_timeTV.setText(runningTime + "시간 사용함");
                remain_timeTV.setTextColor(context.getResources().getColor(R.color.gray));
                content_chart_liveIV.setImageResource(R.drawable.icon_play_red);
                content_kwTV.setTextColor(context.getResources().getColor(R.color.gray));
                content_mc_inverter_modeTV.setTextColor(Color.parseColor("#D71010"));

            } else if (monitoringArray != null && monitoringArray.get(0).getRunning() != null && monitoringArray.get(0).getRunning().equals("1")) {

                if (monitoringArray.get(0).getRemote1() != null && monitoringArray.get(0).getRemote1().equals("1")) {
                    content_mc_stateTV.setText("[원격 기동중]");

                } else {
                    content_mc_stateTV.setText("[로컬 기동중]");
                }

                remain_timeTV.setText(runningTime + "시간 사용중");
                content_mc_stateTV.setTextColor(context.getResources().getColor(R.color.light_blue));
                remain_timeTV.setTextColor(context.getResources().getColor(R.color.light_blue));

                content_chart_liveIV.setImageResource(R.drawable.icon_play_blue);
                content_kwTV.setTextColor(context.getResources().getColor(R.color.light_blue));
                content_mc_stateTV.setTextColor(context.getResources().getColor(R.color.light_blue));
                content_mc_inverter_modeTV.setTextColor(context.getResources().getColor(R.color.light_blue));

            } else if (monitoringArray != null && monitoringArray.get(0).getRunning() != null && monitoringArray.get(0).getRunning().equals("0")) {

                if (monitoringArray.get(0).getEcoStop() != null && monitoringArray.get(0).getEcoStop().equals("1")) {
                    content_mc_stateTV.setText("[절전모드]");
                    content_chart_liveIV.setImageResource(R.drawable.icon_play_green);
                    content_mc_stateTV.setTextColor(Color.parseColor("#32ae0d"));

                } else {
                    content_mc_stateTV.setText("[기동중지]");
                    content_mc_stateTV.setTextColor(context.getResources().getColor(R.color.gray));
                    content_chart_liveIV.setImageResource(R.drawable.icon_play_gray);
                }

                remain_timeTV.setText(runningTime + "시간 사용함");
                remain_timeTV.setTextColor(context.getResources().getColor(R.color.gray));
                content_kwTV.setTextColor(context.getResources().getColor(R.color.gray));
                content_mc_inverter_modeTV.setTextColor(context.getResources().getColor(R.color.gray));

            } else {
                content_mc_stateTV.setText("[기동중지]");
                remain_timeTV.setText(runningTime + "시간 사용함");
                remain_timeTV.setTextColor(context.getResources().getColor(R.color.gray));
                content_mc_stateTV.setTextColor(context.getResources().getColor(R.color.gray));

                content_chart_liveIV.setImageResource(R.drawable.icon_play_gray);
                content_kwTV.setTextColor(context.getResources().getColor(R.color.gray));
                content_mc_stateTV.setTextColor(context.getResources().getColor(R.color.gray));
                content_mc_inverter_modeTV.setTextColor(context.getResources().getColor(R.color.gray));
            }

            //교번운전 마스터
            if (monitoringArray != null && data.getMcYeonYn() != null && data.getMcYeonYn().equals("Y")) {
                int time_t = Integer.parseInt(Common.getInstance().isNullToZero(monitoringArray.get(0).getCrossTimeT()));
                int cross_time = Integer.parseInt(Common.getInstance().isNullToZero(data.getMcYeonCrossTime()));
                int remain_time = cross_time - time_t;

                cross_timeTV.setVisibility(View.VISIBLE);
            /*
                if(data.getMcYeonType().equals("M")){
                    cross_timeTV.setTextColor(Color.BLUE);
                   cross_timeTV.setText("M"+data.getMcCrossNum()+"("+ remain_time + "분 남음)");
                }else if(data.getMcYeonType().equals("S")){
                    cross_timeTV.setTextColor(Color.BLUE);
                   cross_timeTV.setText("S"+data.getMcCrossNum());
                }
                getMqttYeonType
             */

                if (monitoringArray != null && monitoringArray.get(0).getMqttYeonType() != null && monitoringArray.get(0).getMqttYeonType().equals("7")) {
                    cross_timeTV.setTextColor(Color.BLUE);
                    if (data.getMcCrossYn().equals("Y")) {
                        cross_timeTV.setText("MASTER ( " + data.getMcCrossNum() + " ) " + remain_time + "분 남음");
                    } else {
                        cross_timeTV.setText("MASTER ( " + data.getMcCrossNum() + " ) ");
                    }
                } else if (monitoringArray != null && monitoringArray.get(0).getMqttYeonType() != null && monitoringArray.get(0).getMqttYeonType().equals("8")) {
                    cross_timeTV.setTextColor(Color.BLUE);
                    cross_timeTV.setText("SLAVE ( " + data.getMcCrossNum() + " )");
                }

            }

            if (monitoringArray == null) {
                data.setDelFlag("STOP");
                content_mc_powerIV.setImageResource(R.drawable.icon_power_off_big);
                data.setSelected(false);

            } else if (monitoringArray.get(0).getRemote1() == null) {
                data.setDelFlag("STOP");
                content_mc_powerIV.setImageResource(R.drawable.icon_power_off_big);
                data.setSelected(false);

            } else if (monitoringArray.get(0).getRemote1().equals("1")) {
                content_mc_powerIV.setImageResource(R.drawable.icon_power_on_big);
                data.setDelFlag("MM");
                data.setSelected(true);

            } else if (monitoringArray.get(0).getRemote1().equals("0")) {
                data.setDelFlag("STOP");
                content_mc_powerIV.setImageResource(R.drawable.icon_power_off_big);
                data.setSelected(false);
            }

            //소모시간 프로그레스 초기화
            int cycle = Integer.parseInt(Common.getInstance().isNullToZero(data.getMcCycle()));
            if (runningTime > cycle) {
                content_mc_runningPB.setProgressTintList(ColorStateList.valueOf(context.getColor(R.color.red)));
                remain_timeTV.setText("소모품 만료");
                remain_timeTV.setTextColor(context.getResources().getColor(R.color.red));
                content_mc_running_minTV.setText(runningTime + "");
                runningTime = cycle;

            } else {
                content_mc_running_minTV.setText(runningTime + "");
            }
            double per;
            if (cycle == 0 && runningTime != 0) {
                per = 1000;
            } else {
                per = ((double) runningTime / (double) cycle) * 1000;
            }

            content_mc_runningPB.setMax(1000);
            content_mc_runningPB.setProgress((int) per);
            content_mc_running_maxTV.setText("MAX : " + cycle);

            if (data.isShow_position() && !data.isLast_position()) {
                content_air_lineTV.setVisibility(View.VISIBLE);
                contentLL.setBackgroundResource(R.drawable.bg_round_white_top_20);

            } else if (data.isShow_position() && data.isLast_position()) {
                content_air_lineTV.setVisibility(View.VISIBLE);
                contentLL.setBackgroundResource(R.drawable.bg_round_white_20);

            } else if (data.isLast_position()) {
                content_air_lineTV.setVisibility(View.GONE);
                contentLL.setBackgroundResource(R.drawable.bg_round_white_bottom_20);

            } else {
                content_air_lineTV.setVisibility(View.GONE);
                contentLL.setBackgroundResource(R.color.white);
            }
        }

        void get_MonitoringArray(MachineItem data) {

            String current_max, temperature_max, pressure_max, temperature = "0", pressure = "0.0", temp_temperature, temp_pressure;
            float current = 0f, power = 0f;
            MonitoringData monitoringData;

            if (monitoringArray == null) {
                monitoringData = new MonitoringData("0", "0", "0", "0", "0", "0", "0", "0.0", "0.0", "0.0", mac);
            } else {
                monitoringData = monitoringArray.get(0);
            }

            //전력차트
            if (monitoringData.getPowerConsumption() != null && !monitoringData.getPowerConsumption().equals("0")) {
                power = Float.parseFloat(monitoringData.getPowerConsumption()) / 1000;
            }

            setBarChart(power_consumptionBC, power, data.getMcPowerConsumptionMax(), power_consumption_valueTV, "100000", "100000");

            //전류차트 1
            if (monitoringData.getCurrent1() != null && !monitoringData.getCurrent1().equals("0")) {
                current = Float.parseFloat(monitoringData.getCurrent1());
            } else {
                current = 0;
            }

            current_max = data.getMcCurrent1Max();

            if (TextUtils.isEmpty(current_max) || Float.parseFloat(current_max) < 1) {
                current_max = "75";
            }

            setBarChart(current1BC, current, current_max, current1_valueTV, data.getMcCurrent1Up(), data.getMcCurrent1Down());

            //전류차트 2
            if (monitoringData.getCurrent2() != null && !monitoringData.getCurrent2().equals("0")) {
                current = Float.parseFloat(monitoringData.getCurrent2());
            } else {
                current = 0;
            }

            current_max = data.getMcCurrent2Max();

            if (TextUtils.isEmpty(current_max) || Float.parseFloat(current_max) < 1) {
                current_max = "75";
            }

            setBarChart(current2BC, current, current_max, current2_valueTV, data.getMcCurrent2Up(), data.getMcCurrent2Down());

            //전류차트 3
            if (monitoringData.getCurrent3() != null && !monitoringData.getCurrent3().equals("0")) {
                current = Float.parseFloat(monitoringData.getCurrent3());
            } else {
                current = 0;
            }

            current_max = data.getMcCurrent3Max();

            if (TextUtils.isEmpty(current_max) || Float.parseFloat(current_max) < 1) {
                current_max = "75";
            }

            setBarChart(current3BC, current, current_max, current3_valueTV, data.getMcCurrent3Up(), data.getMcCurrent3Down());

            //온도차트 1
            if (monitoringData.getTempNtc() != null && !monitoringData.getTempNtc().equals("0")) {

                temp_temperature = Common.getInstance().valueConvert(monitoringData.getTempNtc());
                temperature = temp_temperature;
            } else {
                temperature = "0";
            }

            temperature_max = Common.getInstance().valueConvert(data.getMcTempNtcMax());

            if (TextUtils.isEmpty(temperature_max) || Float.parseFloat(temperature_max) < 1) {
                temperature_max = "120";
            }

            temperature1_maxTV.setText(temperature_max);
            setPieChart(temperature, Float.parseFloat(temperature_max), temperature1PC, data.getMcTempNtcUp(), data.getMcTempNtcDown());

            //온도차트 2
            if (monitoringData.getTempNtc2() != null && !monitoringData.getTempNtc2().equals("0")) {

                temp_temperature = Common.getInstance().valueConvert(monitoringData.getTempNtc2());
                temperature = temp_temperature;
            } else {
                temperature = "0";
            }

            temperature_max = Common.getInstance().valueConvert(data.getMcTempNtc2Max());

            if (TextUtils.isEmpty(temperature_max) || Float.parseFloat(temperature_max) < 1) {
                temperature_max = "120";
            }
            temperature3_maxTV.setText(temperature_max);
            setPieChart(temperature, Float.parseFloat(temperature_max), temperature3PC, data.getMcTempNtc2Up(), data.getMcTempNtc2Down());

            //온도차트 3
            if (monitoringData.getTempPt100() != null && !monitoringData.getTempPt100().equals("0")) {

                temp_temperature = Common.getInstance().valueConvert(monitoringData.getTempPt100());
                temperature = temp_temperature;
            } else {
                temperature = "0";
            }

            temperature_max = Common.getInstance().valueConvert(data.getMcTempPtMax());

            if (TextUtils.isEmpty(temperature_max) || Float.parseFloat(temperature_max) < 1) {
                temperature_max = "120";
            }
            temperature2_maxTV.setText(temperature_max);
            setPieChart(temperature, Float.parseFloat(temperature_max), temperature2PC, data.getMcTempPtUp(), data.getMcTempPtDown());


            //압력차트 1
            if (monitoringData.getPressure1() != null && !monitoringData.getPressure1().equals("0")) {

                temp_pressure = Common.getInstance().valueConvert1(monitoringData.getPressure1());
                pressure = temp_pressure;
            } else {
                pressure = "0.0";
            }

            pressure_max = data.getMcPressure1Max();

            if (TextUtils.isEmpty(pressure_max) || Float.parseFloat(pressure_max) < 1) {
                pressure_max = "10.0";
            }

            setPieChart(pressure, Float.parseFloat(pressure_max), pressure1PC, data.getMcPressure1Up(), data.getMcPressure1Down());

            //압력차트 2
            if (monitoringData.getPressure2() != null && !monitoringData.getPressure2().equals("0")) {

                temp_pressure = Common.getInstance().valueConvert1(monitoringData.getPressure2());
                pressure = temp_pressure;
            } else {
                pressure = "0.0";
            }

            pressure_max = data.getMcPressure2Max();

            if (TextUtils.isEmpty(pressure_max) || Float.parseFloat(pressure_max) < 1) {
                pressure_max = "10.0";
            }

            setPieChart(pressure, Float.parseFloat(pressure_max), pressure2PC, data.getMcPressure2Up(), data.getMcPressure2Down());

            //압력차트 3
            if (monitoringData.getPressure3() != null && !monitoringData.getPressure3().equals("0")) {

                temp_pressure = Common.getInstance().valueConvert1(monitoringData.getPressure3());
                pressure = temp_pressure;
            } else {
                pressure = "0.0";
            }

            pressure_max = data.getMcPressure3Max();

            if (pressure_max == null || pressure_max.equals("0") || Float.parseFloat(pressure_max) < 1) {
                pressure_max = "10.0";
            }
            setPieChart(pressure, Float.parseFloat(pressure_max), pressure3PC, data.getMcPressure3Up(), data.getMcPressure3Down());

        }

        private void setBarChart(BarChart barChart, Float value, String max, TextView textView, String currentUp, String currentDown) {

            if (barChart.getId() == R.id.power_consumptionBC) {
                String content = Common.getInstance().valueConvert(value + "") + "kW";
                SpannableString spannableString = new SpannableString(content);

                String word = "kW";
                int start = content.indexOf(word);
                int end = start + word.length();

                spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#000000")), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                spannableString.setSpan(new StyleSpan(Typeface.BOLD), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                spannableString.setSpan(new RelativeSizeSpan(0.8f), start, end, SpannableString.SPAN_EXCLUSIVE_EXCLUSIVE);
                textView.setText(spannableString);

            } else {
                String content = Common.getInstance().valueConvert(value + "") + "A";
                SpannableString spannableString = new SpannableString(content);

                String word = "A";
                int start = content.indexOf(word);
                int end = start + word.length();

                spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#000000")), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                spannableString.setSpan(new StyleSpan(Typeface.BOLD), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                spannableString.setSpan(new RelativeSizeSpan(0.8f), start, end, SpannableString.SPAN_EXCLUSIVE_EXCLUSIVE);
                textView.setText(spannableString);
            }

            //값이 한계치를 넘으면 한계치로 값을 재설정함
            if (value >= Float.parseFloat(max)) {
                value = Float.parseFloat(max);
            }

            ArrayList<BarEntry> bar_entries = new ArrayList<>();
            bar_entries.add(new BarEntry(0, value));

            // 변수로 받아서 넣어줘도 됨
            BarDataSet dataSet = new BarDataSet(bar_entries, "");
            dataSet.setAxisDependency(YAxis.AxisDependency.RIGHT);

            if (barChart.getId() == R.id.power_consumptionBC) {
                dataSet.setColor(ContextCompat.getColor(context, R.color.bar_chart_green));
                barChart.setRenderer(new RoundedBarChart(barChart, barChart.getAnimator(), barChart.getViewPortHandler()));
            } else {

                //경고
                if (value >= Float.parseFloat(max)) {
                    dataSet.setColor(ContextCompat.getColor(context, R.color.red));
                    //주의
                } else if (value > Float.parseFloat(currentUp) || value < Float.parseFloat(currentDown)) {
                    dataSet.setColor(ContextCompat.getColor(context, R.color.dark_yellow));
                    barChart.setRenderer(new RoundedBarChart(barChart, barChart.getAnimator(), barChart.getViewPortHandler()));
                    //정상
                } else {
                    dataSet.setColor(ContextCompat.getColor(context, R.color.bar_chart_green));

                    barChart.setRenderer(new RoundedBarChart(barChart, barChart.getAnimator(), barChart.getViewPortHandler()));
                }
            }


            dataSet.setBarShadowColor(Color.parseColor("#EAEAEA"));
            dataSet.setDrawValues(false);

            barChart.setDrawBarShadow(true); // 그래프 그림자
            barChart.setTouchEnabled(false); // 차트 터치 막기
            barChart.setDrawValueAboveBar(true); // 입력값이 차트 위 or 아래에 그려질 건지 (true=위, false=아래)
            barChart.setPinchZoom(false); // 두손가락으로 줌 설정
            barChart.setDrawGridBackground(false); // 격자구조
            barChart.setDescription(null); // 그래프 오른쪽 하단에 라벨 표시
            barChart.getLegend().setEnabled(false); // 차트 범례 설정(legend object chart)
            barChart.setExtraOffsets(5, -50, 0, -50);
            barChart.setNoDataText("데이터 없음");

            //x축
            XAxis xAxis = barChart.getXAxis();
            xAxis.setEnabled(false);
            xAxis.setDrawGridLines(false);
            xAxis.setDrawAxisLine(false);
            xAxis.setPosition(XAxis.XAxisPosition.BOTTOM);

            //y축
            YAxis yAxisL = barChart.getAxisLeft();
            YAxis yAxisR = barChart.getAxisRight();
            yAxisL.setDrawAxisLine(false);
            yAxisL.setDrawLabels(false);
            yAxisL.setDrawGridLines(false);
            yAxisR.setDrawGridLines(false);
            yAxisR.setDrawAxisLine(false);
            yAxisR.setDrawLabels(true);
            yAxisR.setLabelCount(2, true);

            BarData data = new BarData(dataSet);

            if (barChart.getId() == R.id.power_consumptionBC) {
                yAxisR.setXOffset(-5f);
                data.setBarWidth(0.65f);
                yAxisR.setAxisMaximum(Float.parseFloat(max));
                yAxisR.setAxisMinimum(0);
            } else {
                yAxisR.setAxisMaximum(Float.parseFloat(max));
                yAxisR.setXOffset(-9f);
                yAxisR.setAxisMinimum(0);
                data.setBarWidth(0.45f);
            }

            barChart.setData(data);
            barChart.invalidate();
        }

        private void setPieChart(String number, float max, PieChart pieChart, String caution_up, String caution_down) {

            PieDataSet dataSet;

            ArrayList<PieEntry> values = new ArrayList<>();

            if (pieChart.getId() == R.id.temperature1PC || pieChart.getId() == R.id.temperature2PC || pieChart.getId() == R.id.temperature3PC) {

                pieChart.setMaxAngle(180f);
                pieChart.setRotationAngle(180f);
                pieChart.setHoleRadius(65f);
                pieChart.setExtraOffsets(5f, -55f, 5f, -95f);
                pieChart.setCenterTextOffset(0, -10);
                pieChart.setCenterTextSize(20f);

                int count = 0;

                if (Integer.parseInt(number) > 0) {
                    count = Integer.parseInt(Common.getInstance().valueConvert(number));
                }

                if (count >= max) count = (int) max;

                values.add(new PieEntry(count, (Drawable) null));
                values.add(new PieEntry(max - count, (Drawable) null));

                dataSet = new PieDataSet(values, "");

                //경고
                if (count >= max) {
                    dataSet.setColors(Color.parseColor("#CC2828"), Color.parseColor("#EAEAEA"));

                    //주의
                } else if (count > Float.parseFloat(caution_up) || count < Float.parseFloat(caution_down)) {
                    dataSet.setColors(Color.parseColor("#FFC300"), Color.parseColor("#EAEAEA"));

                    //정상
                } else {
                    dataSet.setColors(Color.parseColor("#0075BF"), Color.parseColor("#EAEAEA"));
                }

                String content = number + "℃";
                SpannableString spannableString = new SpannableString(content);

                String word = "℃";
                int start = content.indexOf(word);
                int end = start + word.length();

                spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#000000")), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                spannableString.setSpan(new StyleSpan(Typeface.BOLD), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                spannableString.setSpan(new RelativeSizeSpan(0.7f), start, end, SpannableString.SPAN_EXCLUSIVE_EXCLUSIVE);

                pieChart.setCenterText(spannableString);

            } else {

                pieChart.setHoleRadius(80f);
                pieChart.setCenterTextSize(27f);

                float count = Float.parseFloat(Common.getInstance().valueConvert1(number));

                if (count >= max) count = max;

                values.add(new PieEntry(count, (Drawable) null));
                values.add(new PieEntry(max - count, (Drawable) null));

                dataSet = new PieDataSet(values, "");

                if (count >= max) {
                    dataSet.setColors(Color.parseColor("#CC2828"), Color.parseColor("#EAEAEA"));

                } else if (count > Float.parseFloat(caution_up) || count < Float.parseFloat(caution_down)) {
                    dataSet.setColors(Color.parseColor("#FFC300"), Color.parseColor("#EAEAEA"));

                } else {
                    dataSet.setColors(Color.parseColor("#0075BF"), Color.parseColor("#EAEAEA"));

                }

                String content = number + "Bar\nMAX " + max;
                SpannableString spannableString = new SpannableString(content);

                String word = "Bar";
                int start = content.indexOf(word);
                int end = content.length();

                spannableString.setSpan(new StyleSpan(Typeface.BOLD), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                spannableString.setSpan(new RelativeSizeSpan(0.3f), start, end, SpannableString.SPAN_EXCLUSIVE_EXCLUSIVE);

                pieChart.setCenterText(spannableString);
            }

            dataSet.setSliceSpace(1);
            dataSet.setSelectionShift(0f);

            pieChart.setDrawHoleEnabled(true);
            pieChart.setHoleColor(Color.WHITE);
            pieChart.setUsePercentValues(true);
            pieChart.getDescription().setEnabled(false);
            pieChart.setRotationEnabled(false);
            pieChart.setDrawCenterText(true);
            pieChart.setNoDataText("데이터 없음");

            pieChart.setCenterTextColor(Color.BLACK);
            pieChart.setEntryLabelColor(Color.WHITE);
            pieChart.getLegend().setEnabled(false);

            PieData data = new PieData(dataSet);
            data.setValueFormatter(new PercentFormatter());
            data.setDrawValues(false);

            pieChart.setData(data);
            pieChart.invalidate();

        }
    }
}
