package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Lately.LatelyData;
import kr.co.compcarecompany.Data.Product.AlarmData;
import kr.co.compcarecompany.R;

public class DlgAlarmListAdapter extends RecyclerView.Adapter<DlgAlarmListAdapter.ItemViewHolder> {

    Context context;

    private ArrayList<AlarmData> items = new ArrayList<>();
    private DlgAlarmListDetailAdapter adapter;
    private String type;

    private DlgAlarmListAdapter.detailClickListener detailClickListener;

    public interface detailClickListener {
        void clickBtn(Bundle bundle);
    }

    public DlgAlarmListAdapter(@NonNull Context context, String type, DlgAlarmListAdapter.detailClickListener detailClickListener) {
        this.context = context;
        this.type = type;
        this.detailClickListener = detailClickListener;
    }

    @NonNull
    @Override
    public DlgAlarmListAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_dlg_alarm_list, viewGroup, false);

        return new DlgAlarmListAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull DlgAlarmListAdapter.ItemViewHolder itemViewHolder, int position) {
        itemViewHolder.onBind(items.get(position));
        itemViewHolder.dlg_alarm_listRV.setItemViewCacheSize(items.size());

        adapter = new DlgAlarmListDetailAdapter(context, type, new DlgAlarmListDetailAdapter.detailClickListener() {
            @Override
            public void clickBtn(Bundle bundle) {
                detailClickListener.clickBtn(bundle);
            }
        });

        itemViewHolder.dlg_alarm_listRV.setAdapter(adapter);
        adapter.addItem(items.get(position).getTimeLineAlarms());

    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<AlarmData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView dlg_pd_nameTV;
        RecyclerView dlg_alarm_listRV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            dlg_pd_nameTV = itemView.findViewById(R.id.dlg_pd_nameTV);
            dlg_alarm_listRV = itemView.findViewById(R.id.dlg_alarm_listRV);
        }

        void onBind(AlarmData data) {

            dlg_pd_nameTV.setText(data.getPdName());

        }
    }
}
