package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.provider.ContactsContract;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.AlarmData;
import kr.co.compcarecompany.R;

public class DlgAlarmListDetailAdapter extends RecyclerView.Adapter<DlgAlarmListDetailAdapter.ItemViewHolder> {

    private Context context;
    private String type;
    private DlgAlarmListDetailAdapter.detailClickListener detailClickListener;

    public interface detailClickListener {
        void clickBtn(Bundle bundle);
    }
    private ArrayList<AlarmData> items = new ArrayList<>();

    public DlgAlarmListDetailAdapter(@NonNull Context context,String type, DlgAlarmListDetailAdapter.detailClickListener detailClickListener) {
        this.context = context;
        this.type = type;
        this.detailClickListener = detailClickListener;
    }

    @NonNull
    @Override
    public DlgAlarmListDetailAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
            View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_dlg_alarm_list_detail, viewGroup, false);

        return new DlgAlarmListDetailAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull DlgAlarmListDetailAdapter.ItemViewHolder itemViewHolder, int position) {
        itemViewHolder.onBind(items.get(position));

        if (type.equals("work")) {
            itemViewHolder.reportLL.setVisibility(View.GONE);
            itemViewHolder.workLL.setVisibility(View.VISIBLE);
        }

        itemViewHolder.alarm_detailIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Bundle bundle = new Bundle();
                bundle.putString("time", items.get(position).getPushDt());
                bundle.putString("mc_iot_mac", items.get(position).getMcIotMac());

                switch (items.get(position).getSensor()) {
                    case "1":
                        bundle.putString("type", "current1");
                        break;
                    case "2":
                        bundle.putString("type", "current2");
                        break;
                    case "3":
                        bundle.putString("type", "current3");
                        break;
                    case "4":
                    case "10":
                        bundle.putString("type", "pressure1");
                        break;
                    case "5":
                    case "11":
                        bundle.putString("type", "pressure2");
                        break;
                    case "6":
                    case "12":
                        bundle.putString("type", "pressure3");
                        break;
                    case "7":
                        bundle.putString("type", "temperatureNtc");
                        break;
                    case "8":
                        bundle.putString("type", "temperaturePt");
                        break;
                    case "9":
                        bundle.putString("type", "temperatureNtc2");
                        break;
                }
                detailClickListener.clickBtn(bundle);
            }
        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<AlarmData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView alarm_push_timeTV, alarm_sensorTV, alarm_remove_timeTV, alarm_remove_mb_nameTV,work_push_timeTV, work_memoTV;
        ImageView alarm_detailIV;
        LinearLayout reportLL, workLL;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            alarm_push_timeTV = itemView.findViewById(R.id.alarm_push_timeTV);
            alarm_sensorTV = itemView.findViewById(R.id.alarm_sensorTV);
            alarm_remove_timeTV = itemView.findViewById(R.id.alarm_remove_timeTV);
            alarm_remove_mb_nameTV = itemView.findViewById(R.id.alarm_remove_mb_nameTV);
            alarm_detailIV = itemView.findViewById(R.id.alarm_detailIV);

            reportLL = itemView.findViewById(R.id.reportLL);
            workLL = itemView.findViewById(R.id.workLL);
            work_push_timeTV = itemView.findViewById(R.id.work_push_timeTV);
            work_memoTV = itemView.findViewById(R.id.work_memoTV);

        }

        void onBind(AlarmData data) {

            alarm_push_timeTV.setText(data.getPushDt().substring(2, data.getPushDt().length()-3));
            work_push_timeTV.setText(data.getPushDt().substring(2, data.getPushDt().length()-3));

            if (data.getReadTime() != null)
            alarm_remove_timeTV.setText(data.getReadTime().substring(2, data.getReadTime().length()-3));
            if (data.getMbName() != null) alarm_remove_mb_nameTV.setText(data.getMbName());
            else alarm_remove_mb_nameTV.setText("-");

            String type = "";
            switch (data.getSensor()) {

                case "1":
                    type = "전류1\n" + data.getSensorValue()+"A";
                    break;
                case "2":
                    type = "전류2\n" + data.getSensorValue()+"A";
                    break;
                case "3":
                    type = "전류3\n" + data.getSensorValue()+"A";
                    break;
                case "4":
                case "10":
                    type = "압력1\n" + data.getSensorValue()+"Bar";
                    break;
                case "5":
                case "11":
                    type = "압력2\n" + data.getSensorValue()+"Bar";
                    break;
                case "6":
                case "12":
                    type = "압력3\n" + data.getSensorValue()+"Bar";
                    break;
                case "7":
                    type = "온도NTC\n" + data.getSensorValue()+"℃";
                    break;
                case "8":
                    type = "온도PT100\n" + data.getSensorValue()+"℃";
                    break;
                case "9":
                    type = "온도NTC_2\n" + data.getSensorValue()+"℃";
                    break;
                case "100":
                    type = "기계 한계값 초과";
                    break;
                case "300":
                    type = "인버터 전류 과부하 발생";
                    break;
                case "400":
                    type = "기계 전원 정전 발생";
                    break;
                case "500":
                    type = "메인모터 오버로드";
                    break;
                case "600":
                    type = "팬모터 오버로드";
                    break;
            }

            alarm_sensorTV.setText(type);
            work_memoTV.setText(type);

        }
    }
}

