package kr.co.compcarecompany.Util.Adapter;

import android.app.Activity;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;
import java.util.NoSuchElementException;

import kr.co.compcarecompany.Data.Product.IotProdData;
import kr.co.compcarecompany.R;

public class IoTProdRecyclerAdapter extends RecyclerView.Adapter<IoTProdRecyclerAdapter.ItemViewHolder> {

    private Activity activity;
    Handler handler;
    // adapter에 들어갈 list 입니다.
    private ArrayList<IotProdData> items = new ArrayList<>();

    private IoTProdRecyclerAdapter.OnLoadMoreListener onLoadMoreListener;

    public interface OnLoadMoreListener {
        void onLoadMore(int position);
    }

    private IoTProdRecyclerAdapter.OnRealDataListener OnRealDataListener;

    public interface OnRealDataListener {
        void onRealData(int i, int k1, int k2);
    }

    public IoTProdRecyclerAdapter(Activity activity, Handler handler, IoTProdRecyclerAdapter.OnLoadMoreListener onLoadMoreListener, IoTProdRecyclerAdapter.OnRealDataListener OnRealDataListener) {
        this.onLoadMoreListener = onLoadMoreListener;
        this.OnRealDataListener = OnRealDataListener;
        this.activity = activity;
        this.handler = handler;
    }

    @NonNull
    @Override
    public IoTProdRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_iot_list, parent, false);
        return new IoTProdRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull IoTProdRecyclerAdapter.ItemViewHolder holder, int position) {
        holder.onBind(items.get(position));

        holder.ioTProdDetailRecyclerAdapter.addAll(items.get(position).getMachineItems());
        holder.iot_listRV.setItemViewCacheSize(items.size());

        if (position == getItemCount() - 1) {
            if (onLoadMoreListener != null) {
                onLoadMoreListener.onLoadMore(position);
            }
        }
    }

    public void addAll(ArrayList<IotProdData> lst) {
//        this.items = lst;
        items.clear();
        items.addAll(lst);
        notifyDataSetChanged();
    }

    public void addItemMore(ArrayList<IotProdData> lst) {
        items.addAll(lst);
        notifyItemRangeChanged(0, items.size());
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    public void updateIotData(IotProdData item) {
        int index = this.items.indexOf(item);
        if (index < 0) throw new NoSuchElementException("Cannot find data " + item);
        this.items.set(index, item);
        notifyItemChanged(index);
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView iot_company_cp_nameTV;
        RecyclerView iot_listRV;
        IoTProdDetailRecyclerAdapter ioTProdDetailRecyclerAdapter;

        ItemViewHolder(View itemView) {
            super(itemView);
            iot_company_cp_nameTV = itemView.findViewById(R.id.iot_company_cp_nameTV);
            iot_listRV = itemView.findViewById(R.id.iot_listRV);
            ioTProdDetailRecyclerAdapter = new IoTProdDetailRecyclerAdapter(activity, handler);
            iot_listRV.setAdapter(ioTProdDetailRecyclerAdapter);

        }

        void onBind(IotProdData data) {
            iot_listRV.setItemViewCacheSize(data.getMachineItems().size());
            iot_company_cp_nameTV.setText("[ " + data.getCpName() + " ]");
        }
    }
}
