package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Company.MachineLogData;
import kr.co.compcarecompany.R;

public class MachineLogAdapter extends RecyclerView.Adapter<MachineLogAdapter.ItemViewHolder> {

    Context context;
    Handler handler;

    private ArrayList<MachineLogData> items = new ArrayList<>();

    public MachineLogAdapter(@NonNull Context context) {
        this.context = context;
    }

    @NonNull
    @Override
    public MachineLogAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_machine_log, viewGroup, false);

        return new MachineLogAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MachineLogAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<MachineLogData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView item_log_dateTV, item_log_product_nameTV, item_log_macTV, item_log_stateTV, item_log_nameTV, item_log_titleTV, item_log_date_titleTV, item_log_product_qrTV;
        LinearLayout item_log_nameLL;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            item_log_dateTV = itemView.findViewById(R.id.item_log_dateTV);
            item_log_product_nameTV = itemView.findViewById(R.id.item_log_product_nameTV);
            item_log_macTV = itemView.findViewById(R.id.item_log_macTV);
            item_log_stateTV = itemView.findViewById(R.id.item_log_stateTV);
            item_log_nameTV = itemView.findViewById(R.id.item_log_nameTV);
            item_log_titleTV = itemView.findViewById(R.id.item_log_titleTV);
            item_log_nameLL = itemView.findViewById(R.id.item_log_nameLL);
            item_log_date_titleTV = itemView.findViewById(R.id.item_log_date_titleTV);
            item_log_product_qrTV = itemView.findViewById(R.id.item_log_product_qrTV);

        }
        // IoT 타임라인 로그 데이터 표기
        void onBind(MachineLogData data) {
            item_log_date_titleTV.setText("알림 발생일시"); // 1번
            item_log_dateTV.setText(data.getInsDt()); // 1번
            item_log_product_nameTV.setText(data.getPdName()); // 2번
            item_log_product_qrTV.setText(data.getQrCode());//3번
            item_log_macTV.setText(data.getMcIotMac()); //4번

            // 23.08.06 스케줄 ON/OFF 정보 추가
            if (data.getDelFlag() == null) {
                if (data.getMcScheduleYn() != null) {
                    item_log_titleTV.setText("스케줄 활성화"); // 5번
                    if (data.getMcScheduleYn().equals("Y")) {
                        item_log_stateTV.setText("활성");
                        item_log_stateTV.setTextColor(Color.RED);

                    } else {
                        item_log_stateTV.setText("비활성");
                        item_log_stateTV.setTextColor(Color.BLACK);
                    }
                }else {
                    if(data.getMcSensor().equals("0")) {
                        item_log_titleTV.setText("알림내용");
                        item_log_stateTV.setText("iot 재시작");
                        item_log_stateTV.setTextColor(Color.BLACK);
                    }else if (data.getMcSensor().equals("150")){
                        item_log_titleTV.setText("스케쥴운전");
                        item_log_stateTV.setText("OFF");
                        item_log_stateTV.setTextColor(Color.BLACK);
                    }else if (data.getMcSensor().equals("160")){
                        item_log_titleTV.setText("스케쥴운전");
                        item_log_stateTV.setText("ON");
                        item_log_stateTV.setTextColor(Color.RED);
                    }

                    item_log_nameLL.setVisibility(View.GONE);
                }

            } else if (data.getDelFlag() != null) {
                item_log_titleTV.setText("원격운전");
                if (data.getDelFlag().equals("MM")) {
                    item_log_stateTV.setText("ON");
                    item_log_stateTV.setTextColor(Color.RED);
                } else {
                    item_log_stateTV.setText("OFF");
                    item_log_stateTV.setTextColor(Color.BLACK);
                }

            }

            if (data.getMbName() != null) {
                item_log_nameTV.setText(data.getMbName());
            }

        }
        }
    }


