package kr.co.compcarecompany.Util.Adapter;

import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import kr.co.compcarecompany.Data.Product.AlarmData;
import kr.co.compcarecompany.R;

public class MachineManagementDetailAdapter extends RecyclerView.Adapter<MachineManagementDetailAdapter.ItemViewHolder> {

    private ArrayList<AlarmData> items = new ArrayList<>();
    String type = null;

    private MachineManagementDetailAdapter.detailClickListener detailClickListener;

    public interface detailClickListener {
        void clickBtn(Bundle bundle);
    }

    MachineManagementDetailAdapter(MachineManagementDetailAdapter.detailClickListener detailClickListener) {
        this.detailClickListener = detailClickListener;
    }

    MachineManagementDetailAdapter(String type) {
        this.type = type;
    }

    MachineManagementDetailAdapter() {
    }

    @NonNull
    @Override
    public MachineManagementDetailAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_management_detail, viewGroup, false);
        return new MachineManagementDetailAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MachineManagementDetailAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        if (items.get(position).getDelayTime() != null && type == null && items.get(position).getReadTime() != null) {
//            itemViewHolder.alarm_restartTV.setText((Integer.parseInt(items.get(position).getDelayTime()) / 60) + "분 후 재알림");

            String date_str = items.get(position).getReadTime();
            SimpleDateFormat transFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = null;
            try {
                date = transFormat.parse(date_str);
            } catch (ParseException e) {
                e.printStackTrace();
            }

            Date now = new Date();

            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(now); //오늘
            cal2.setTime(date);

            long time = (now.getTime()-date.getTime())/60000;
            long delay_time = Long.parseLong(items.get(position).getDelayTime()) / 60;

            if (time < delay_time) {
                itemViewHolder.alarm_restartTV.setText(delay_time - time + "분 후 재확인");
                itemViewHolder.alarm_restartTV.setTextColor(Color.RED);
            } else {
                itemViewHolder.alarm_restartTV.setText("알람해제 완료");
            }

        } else if (type != null && type.equals("report")) {
            itemViewHolder.alarm_restartTV.setVisibility(View.GONE);
        }

        itemViewHolder.alarm_detailIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Bundle bundle = new Bundle();
                bundle.putString("time", items.get(position).getPushDt());
                bundle.putString("mc_iot_mac", items.get(position).getMcIotMac());

                switch (items.get(position).getSensor()) {
                    case "1":
                        bundle.putString("type", "current1");
                        break;
                    case "2":
                        bundle.putString("type", "current2");
                        break;
                    case "3":
                        bundle.putString("type", "current3");
                        break;
                    case "4":
                    case "10":
                        bundle.putString("type", "pressure1");
                        break;
                    case "5":
                    case "11":
                        bundle.putString("type", "pressure2");
                        break;
                    case "6":
                    case "12":
                        bundle.putString("type", "pressure3");
                        break;
                    case "7":
                        bundle.putString("type", "temperatureNtc");
                        break;
                    case "8":
                        bundle.putString("type", "temperatureNtc2");
                        break;
                    case "9":
                        bundle.putString("type", "temperaturePt");
                        break;
                }

                detailClickListener.clickBtn(bundle);
            }
        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<AlarmData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView alarm_dateTV, alarm_sensorTV, alarm_valueTV, alarm_restartTV;
        ImageView alarm_detailIV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            alarm_dateTV = itemView.findViewById(R.id.alarm_dateTV);
            alarm_sensorTV = itemView.findViewById(R.id.alarm_sensorTV);
            alarm_valueTV = itemView.findViewById(R.id.alarm_valueTV);
            alarm_restartTV = itemView.findViewById(R.id.alarm_restartTV);
            alarm_detailIV = itemView.findViewById(R.id.alarm_detailIV);

        }

        void onBind(AlarmData data) {

            alarm_dateTV.setText(data.getPushDt().substring(2));

            if (data.getSensor() != null) {

                switch (data.getSensor()) {
                    case "0":
                        alarm_sensorTV.setText("IoT 재시작");
                        alarm_detailIV.setVisibility(View.GONE);
                        break;
                    case "1":
                        alarm_sensorTV.setText("전류 1");
                        alarm_valueTV.setText(data.getSensorValue() + " A");
                        break;
                    case "2":
                        alarm_sensorTV.setText("전류 2");
                        alarm_valueTV.setText(data.getSensorValue() + " A");
                        break;
                    case "3":
                        alarm_sensorTV.setText("전류 3");
                        alarm_valueTV.setText(data.getSensorValue() + " A");
                        break;
                    case "4":
                    case "10":
                        alarm_sensorTV.setText("압력 1");
                        alarm_valueTV.setText(data.getSensorValue() + " Bar");
                        break;
                    case "5":
                    case "11":
                        alarm_sensorTV.setText("압력 2");
                        alarm_valueTV.setText(data.getSensorValue() + " Bar");
                        break;
                    case "6":
                    case "12":
                        alarm_sensorTV.setText("압력 3");
                        alarm_valueTV.setText(data.getSensorValue() + " Bar");
                        break;
                    case "7":
                        alarm_sensorTV.setText("온도 NTC 1");
                        alarm_valueTV.setText(data.getSensorValue() + " ℃");
                        break;
                    case "8":
                        alarm_sensorTV.setText("온도 PT100");
                        alarm_valueTV.setText(data.getSensorValue() + " ℃");
                        break;
                    case "9":
                        alarm_sensorTV.setText("온도 NTC 2");
                        alarm_valueTV.setText(data.getSensorValue() + " ℃");
                        break;
                    case "100":
                    case "300":
                    case "400":
                    case "500":
                    case "600":
                        alarm_sensorTV.setText("기계 고장으로 기사 호출");
                        alarm_valueTV.setVisibility(View.GONE);
                        alarm_detailIV.setVisibility(View.GONE);
                        break;
                    case "200":
                        alarm_sensorTV.setText("소모품 만료");
                        alarm_detailIV.setVisibility(View.GONE);
                        break;
                }
            }
        }
    }
}
