package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Activity.FragmentActivity;
import kr.co.compcarecompany.Data.Product.AlarmDatum;
import kr.co.compcarecompany.R;

public class MachineManagementTitleAdapter extends RecyclerView.Adapter<MachineManagementTitleAdapter.ItemViewHolder> {

    private Context context;
    private Handler handler;
    private FragmentActivity frag;

    private MachineManagementTitleAdapter.alarmClickListener alarmClickListener;

    public interface alarmClickListener {
        void clickBtn(Bundle bundle);
    }

    private MachineManagementTitleAdapter.reportClickListener reportClickListener;

    public interface reportClickListener {
        void clickBtn(Bundle bundle);
    }

    private MachineManagementTitleAdapter.returnClickListener returnClickListener;

    public interface returnClickListener {
        void clickBtn();
    }

    private MachineManagementTitleAdapter.detailClickListener detailClickListener;

    public interface detailClickListener {
        void clickBtn(Bundle bundle);
    }

    private MachineManagementTitleAdapter.remove_list_ClickListener remove_list_ClickListener;

    public interface remove_list_ClickListener {
        void clickBtn(Bundle bundle);
    }

    private ArrayList<AlarmDatum> items = new ArrayList<>();

    public MachineManagementTitleAdapter(@NonNull Context context, Handler handler, FragmentActivity frag, MachineManagementTitleAdapter.alarmClickListener alarmClickListener,
                                         MachineManagementTitleAdapter.reportClickListener reportClickListener, MachineManagementTitleAdapter.returnClickListener returnClickListener,
                                         MachineManagementTitleAdapter.detailClickListener detailClickListener, MachineManagementTitleAdapter.remove_list_ClickListener remove_list_ClickListener) {
        this.context = context;
        this.handler = handler;
        this.frag = frag;
        this.alarmClickListener = alarmClickListener;
        this.reportClickListener = reportClickListener;
        this.returnClickListener = returnClickListener;
        this.detailClickListener = detailClickListener;
        this.remove_list_ClickListener = remove_list_ClickListener;
    }

    @NonNull
    @Override
    public MachineManagementTitleAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_machine_management_title, viewGroup, false);
        return new MachineManagementTitleAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MachineManagementTitleAdapter.ItemViewHolder itemViewHolder, int position) {
        itemViewHolder.onBind(items.get(position));

        itemViewHolder.adapter = new MachineManagementContentAdapter(context, handler, frag, new MachineManagementContentAdapter.alarmClickListener() {
            @Override
            public void clickBtn(Bundle bundle) {
                //알람 >> 알람해제 클릭 리스너
//                alarmClickListener.clickBtn(bundle);
            }
        }, new MachineManagementContentAdapter.reportClickListener() {
            @Override
            public void clickBtn(Bundle bundle) {
                //알람 >> 작업일지 클릭 리스너
                bundle.putString("position_i", position + "");
                reportClickListener.clickBtn(bundle);
            }
        }, new MachineManagementContentAdapter.returnClickListener() {
            @Override
            public void clickBtn() {
                //알람 >> 작업일지 눌렀을 때 해제되지 않은 알람이 있을 경우
//                returnClickListener.clickBtn();
            }
        }, new MachineManagementContentAdapter.detailClickListener() {
            @Override
            public void clickBtn(Bundle bundle) {
                //알람 >> 알람리스트에서 상세 팝업
                detailClickListener.clickBtn(bundle);
            }
        });

        itemViewHolder.reportLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                boolean remain_alarm = false;

                Loop1:
                for (int k = 0; k < items.get(position).getAlarmList().size(); k++) {
                    if (items.get(position).getAlarmList().get(k).getCtAlarms() != null) {
                        for (int i = 0; i < items.get(position).getAlarmList().get(k).getCtAlarms().size(); i++) {
                            if (items.get(position).getAlarmList().get(k).getCtAlarms().get(i).getDelayTime() == null) {
                                remain_alarm = true;
                                break Loop1;
                            }
                        }
                    }

                    if (items.get(position).getAlarmList().get(k).getPrAlarms() != null) {
                        for (int i = 0; i < items.get(position).getAlarmList().get(k).getPrAlarms().size(); i++) {
                            if (items.get(position).getAlarmList().get(k).getPrAlarms().get(i).getDelayTime() == null) {
                                remain_alarm = true;
                                break Loop1;
                            }
                        }
                    }

                    if (items.get(position).getAlarmList().get(k).getTempAlarms() != null) {
                        for (int i = 0; i < items.get(position).getAlarmList().get(k).getTempAlarms().size(); i++) {
                            if (items.get(position).getAlarmList().get(k).getTempAlarms().get(i).getDelayTime() == null) {
                                remain_alarm = true;
                                break Loop1;
                            }
                        }
                    }
                }

                if (remain_alarm) {
                    returnClickListener.clickBtn();

                } else {
                    Bundle bundle = new Bundle();
                    bundle.putString("mc_airline", items.get(position).getAlarmList().get(0).getMcAirline());
                    bundle.putString("cp_idx", items.get(position).getCpIdx());
                    reportClickListener.clickBtn(bundle);
                }
            }
        });

        itemViewHolder.alarm_removeLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                ArrayList<String> mac_list = new ArrayList<>();
                ArrayList<String> msg_list = new ArrayList<>();

                for (int k = 0; k < items.get(position).getAlarmList().size(); k++) {
                    if (items.get(position).getAlarmList().get(k).getCtAlarms() != null) {
                        for (int i = 0; i < items.get(position).getAlarmList().get(k).getCtAlarms().size(); i++) {
                            if (items.get(position).getAlarmList().get(k).getCtAlarms().get(i).getDelayTime() == null) {
                                mac_list.add(items.get(position).getAlarmList().get(k).getCtAlarms().get(i).getMcIotMac());
                                msg_list.add(items.get(position).getAlarmList().get(k).getCtAlarms().get(i).getSensor());
                            }
                        }
                    }
                    if (items.get(position).getAlarmList().get(k).getPrAlarms() != null) {
                        for (int i = 0; i < items.get(position).getAlarmList().get(k).getPrAlarms().size(); i++) {
                            if (items.get(position).getAlarmList().get(k).getPrAlarms().get(i).getDelayTime() == null) {
                                mac_list.add(items.get(position).getAlarmList().get(k).getPrAlarms().get(i).getMcIotMac());
                                msg_list.add(items.get(position).getAlarmList().get(k).getPrAlarms().get(i).getSensor());
                            }
                        }
                    }
                    if (items.get(position).getAlarmList().get(k).getTempAlarms() != null) {
                        for (int i = 0; i < items.get(position).getAlarmList().get(k).getTempAlarms().size(); i++) {
                            if (items.get(position).getAlarmList().get(k).getTempAlarms().get(i).getDelayTime() == null) {
                                mac_list.add(items.get(position).getAlarmList().get(k).getTempAlarms().get(i).getMcIotMac());
                                msg_list.add(items.get(position).getAlarmList().get(k).getTempAlarms().get(i).getSensor());
                            }
                        }
                    }
                }

                Bundle bundle = new Bundle();
                bundle.putStringArrayList("mac_list", mac_list);
                bundle.putStringArrayList("msg_list", msg_list);

                alarmClickListener.clickBtn(bundle);
            }
        });

        itemViewHolder.remove_listLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Bundle bundle = new Bundle();
                bundle.putString("cp_idx", items.get(position).getCpIdx());
                bundle.putString("mc_airline", items.get(position).getAlarmList().get(0).getMcAirline());
                remove_list_ClickListener.clickBtn(bundle);
            }
        });

        itemViewHolder.alarm_contentRV.setAdapter(itemViewHolder.adapter);
        itemViewHolder.adapter.addItem(items.get(position).getAlarmList());
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<AlarmDatum> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        /**
         * 상단 정보
         **/
        TextView cp_nameTV, air_lineTV;
        RecyclerView alarm_contentRV;
        MachineManagementContentAdapter adapter;
        LinearLayout alarm_removeLL, reportLL, remove_listLL;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            cp_nameTV = itemView.findViewById(R.id.cp_nameTV);
            air_lineTV = itemView.findViewById(R.id.air_lineTV);
            alarm_contentRV = itemView.findViewById(R.id.alarm_contentRV);
            alarm_removeLL = itemView.findViewById(R.id.alarm_removeLL);
            reportLL = itemView.findViewById(R.id.reportLL);
            remove_listLL = itemView.findViewById(R.id.remove_listLL);
        }

        void onBind(AlarmDatum data) {
            cp_nameTV.setText(data.getCpName());
            air_lineTV.setText("[ " + data.getCpAirlineStr() + " ]");
        }
    }
}
