package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Memo.Login.UserItem;
import kr.co.compcarecompany.R;

public class MemberManagementAdapter extends RecyclerView.Adapter<MemberManagementAdapter.ItemViewHolder> {

    Context context;
    Handler handler;

    private MemberManagementAdapter.managementListener managementListener;

    public interface managementListener {
        void clickBtn(String mb_idx);
    }

    private ArrayList<UserItem> items = new ArrayList<>();

    public MemberManagementAdapter(@NonNull Context context, MemberManagementAdapter.managementListener managementListener) {
        this.context = context;
        this.managementListener = managementListener;
    }

    @NonNull
    @Override
    public MemberManagementAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_member_management, viewGroup, false);
        return new MemberManagementAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MemberManagementAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        itemViewHolder.item_mb_delTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                managementListener.clickBtn(items.get(position).getMbId());
            }
        });

        itemViewHolder.item_mb_revivalTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                managementListener.clickBtn(items.get(position).getMbId());
            }
        });
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<UserItem> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView item_mb_idTV, item_mb_nameTV, item_mb_phoneTV, item_mb_delTV, item_mb_revivalTV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            item_mb_idTV = itemView.findViewById(R.id.item_mb_idTV);
            item_mb_nameTV = itemView.findViewById(R.id.item_mb_nameTV);
            item_mb_phoneTV = itemView.findViewById(R.id.item_mb_phoneTV);
            item_mb_delTV = itemView.findViewById(R.id.item_mb_delTV);
            item_mb_revivalTV = itemView.findViewById(R.id.item_mb_revivalTV);
        }

        void onBind(UserItem data) {

            item_mb_idTV.setText(data.getMbId());
            item_mb_nameTV.setText(data.getMbName());
            item_mb_phoneTV.setText(data.getMbPhone());
            if (data.getMbDenied().equals("Y")) {
                item_mb_revivalTV.setVisibility(View.VISIBLE);
                item_mb_delTV.setVisibility(View.GONE);
            } else {
                item_mb_delTV.setVisibility(View.VISIBLE);
                item_mb_revivalTV.setVisibility(View.GONE);
            }
        }
    }
}
