package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.Switch;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Company.CompanyData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;
import kr.co.compcarecompany.Util.MyOnItemClick;

public class MenuAlarmAdapter extends RecyclerView.Adapter<MenuAlarmAdapter.ItemViewHolder> {

    Context context;
    Handler handler;
    MyOnItemClick callback;

    private ArrayList<CompanyData> items = new ArrayList<>();

    public MenuAlarmAdapter(@NonNull Context context, MyOnItemClick callback) {
        this.context = context;
        this.callback = callback;
    }

    @NonNull
    @Override
    public MenuAlarmAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_alarm_list, viewGroup, false);
        return new MenuAlarmAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MenuAlarmAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        itemViewHolder.alarm_companySW.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {

                boolean state;

                if (isChecked) {
                    state = true;

                } else {
                    state = false;
                }

                Bundle bundle = new Bundle();
                bundle.putString("cp_idx", items.get(position).getCpIdx());
                bundle.putBoolean("state", state);
                callback.onClick(bundle);
            }
        });
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<CompanyData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView alarm_companyTV;
        Switch alarm_companySW;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            alarm_companyTV = itemView.findViewById(R.id.alarm_companyTV);
            alarm_companySW = itemView.findViewById(R.id.alarm_companySW);
        }

        void onBind(CompanyData data) {

            //리사이클러뷰 초기화 중 스위치 세팅
            if (Common.getInstance().getPref(itemView.getContext(), data.getCpIdx(), true)) {
                alarm_companySW.setChecked(true);

            } else {
                alarm_companySW.setChecked(false);
            }

            alarm_companyTV.setText(data.getCpName());

        }
    }
}
