package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.MachineItem;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class MonitoringCompareTitleAdapter extends RecyclerView.Adapter<MonitoringCompareTitleAdapter.ItemViewHolder> {

    Context context;

    private ArrayList<MachineItem> items = new ArrayList<>();

    public MonitoringCompareTitleAdapter(@NonNull Context context) {
        this.context = context;
    }

    @NonNull
    @Override
    public MonitoringCompareTitleAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_monitoring_compare_title, viewGroup, false);

        return new MonitoringCompareTitleAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MonitoringCompareTitleAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));
        switch (position) {
            case 0 : itemViewHolder.compare_numIV.setBackgroundResource(R.color.color_bg_purple); break;
            case 1 : itemViewHolder.compare_numIV.setBackgroundResource(R.color.bar_chart_green); break;
            case 2 : itemViewHolder.compare_numIV.setBackgroundResource(R.color.pie_chart_green); break;
        }
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<MachineItem> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView compare_pt_nameTV, compare_cp_nameTV, compare_airlineTV, compare_pd_nameTV, compare_mc_specTV, compare_mc_running_timeTV, compare_mc_cycleTV, compare_mc_lotTV, compare_mc_exchange_dtTV;
        ImageView compare_numIV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            compare_pt_nameTV = itemView.findViewById(R.id.compare_pt_nameTV);
            compare_cp_nameTV = itemView.findViewById(R.id.compare_cp_nameTV);
            compare_airlineTV = itemView.findViewById(R.id.compare_airlineTV);
            compare_pd_nameTV = itemView.findViewById(R.id.compare_pd_nameTV);
            compare_mc_specTV = itemView.findViewById(R.id.compare_mc_specTV);
            compare_mc_running_timeTV = itemView.findViewById(R.id.compare_mc_running_timeTV);
            compare_mc_cycleTV = itemView.findViewById(R.id.compare_mc_cycleTV);
            compare_mc_lotTV = itemView.findViewById(R.id.compare_mc_lotTV);
            compare_mc_exchange_dtTV = itemView.findViewById(R.id.compare_mc_exchange_dtTV);
            compare_numIV = itemView.findViewById(R.id.compare_numIV);

        }

        void onBind(MachineItem data) {

            compare_pt_nameTV.setText(data.getPtName());
            compare_pd_nameTV.setText(data.getPdName());
            compare_cp_nameTV.setText("[ " + data.getCpName() + " ]");
            compare_airlineTV.setText(data.getMcAirline());
            compare_mc_specTV.setText(data.getPdSpec());
            compare_mc_running_timeTV.setText(Common.getInstance().isNullToZero(data.getMcRunningtime()) + "시간");
            compare_mc_cycleTV.setText(Common.getInstance().isNullToZero(data.getMcCycle()) + "시간");
            if (data.getMcLot() != null) {
                compare_mc_lotTV.setText(data.getMcLot());
            } else {
                compare_mc_lotTV.setText("-");
            }
            if (data.getMcExchangedt() != null) {
                compare_mc_exchange_dtTV.setText(data.getMcExchangedt() + "");
            } else {
                compare_mc_exchange_dtTV.setText("-");
            }
        }
    }
}

