package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.RelayData;
import kr.co.compcarecompany.R;

public class RelayGridAdapter2 extends RecyclerView.Adapter<RelayGridAdapter2.ItemViewHolder> {

    private Context context;
    private ArrayList<RelayData> items = new ArrayList<>();
    private int item_height;

    public interface OnItemClickListener {
        void onItemClick(int position);
    }

    private RelayGridAdapter2.OnItemClickListener mListener = null;

    public void setOnItemClickListener(RelayGridAdapter2.OnItemClickListener listener) {
        this.mListener = listener;
    }

    public RelayGridAdapter2(@NonNull Context context, int height) {
        this.context = context;
        this.item_height = height;
    }

    @NonNull
    @Override
    public RelayGridAdapter2.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_relay_grid2, viewGroup, false);

        return new RelayGridAdapter2.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull RelayGridAdapter2.ItemViewHolder itemViewHolder, int position) {
        itemViewHolder.onBind(items.get(position));

    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<RelayData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView relay_1TV;

        ItemViewHolder(@NonNull View itemView) {

            super(itemView);
            relay_1TV = itemView.findViewById(R.id.relay_1TV);
        }

        void onBind(RelayData data) {

            itemView.getLayoutParams().height = item_height / 335;

        }
    }
}