package kr.co.compcarecompany.Util.Adapter;

import android.app.AlertDialog;
import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.ortiz.touchview.TouchImageView;
import com.squareup.picasso.Picasso;

import java.util.ArrayList;
import java.util.Objects;

import kr.co.compcarecompany.R;

public class ReportImageAdapter extends RecyclerView.Adapter<ReportImageAdapter.ItemViewHolder> {


    Context context;
    int itemHeight;
    Handler handler;
    String type;

    public interface OnItemClickListener {
        void onItemClick(View v, int position);
    }

    private OnItemClickListener mListener = null;

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mListener = listener;
    }

    // adapter에 들어갈 list 입니다.
    public ArrayList<String> items = new ArrayList<>();
    public ArrayList<String> dataImgNo = new ArrayList<>();

    public ReportImageAdapter(Context context, int itemHeight) {
        this.context = context;
        this.itemHeight = itemHeight;
    }

    public ReportImageAdapter(Context context, int itemHeight, String type) {
        this.context = context;
        this.itemHeight = itemHeight;
        this.type = type;
    }

    @NonNull
    @Override
    public ReportImageAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_alarm_report_image, parent, false);
        return new ReportImageAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ReportImageAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));

        if(type != null && !type.equals("") && !TextUtils.isEmpty(type)){
            holder.removeTV.setVisibility(View.GONE);
        }

        holder.removeTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mListener.onItemClick(v, position);
            }
        });
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<String> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void removeItem(int position) {
        items.remove(position);
        if (dataImgNo.size() > position) {
            dataImgNo.remove(position);
        }
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }


    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        ImageView reportIV;
        TextView removeTV;

        ItemViewHolder(View itemView) {
            super(itemView);
            reportIV = itemView.findViewById(R.id.reportIV);
            removeTV = itemView.findViewById(R.id.removeTV);

        }

        void onBind(String data) {

            if(data.contains("http") && !data.contains("/uploads/machine/")){
                removeTV.setVisibility(View.GONE);
            }

            GradientDrawable drawable = (GradientDrawable) context.getDrawable(R.drawable.border_black_round);
            reportIV.setBackground(drawable);
            reportIV.setClipToOutline(true);

            itemView.getLayoutParams().height = itemHeight / 4;

            try {
                Picasso picasso = new Picasso.Builder(context).listener(new Picasso.Listener() {
                    @Override
                    public void onImageLoadFailed(Picasso picasso, Uri uri, Exception exception) {
                        reportIV.setImageResource(R.drawable.no_img);
                    }
                }).build();

                picasso.with(context).load(data).into(reportIV);
            } catch (Exception e) {
                reportIV.setImageResource(R.drawable.no_img);
            }

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(context);
                    AlertDialog dig = dialogBuilder.create();
                    dig.getWindow().addFlags(WindowManager.LayoutParams.FLAG_BLUR_BEHIND);

                    View view = LayoutInflater.from(context).inflate(R.layout.dlg_image, null);
                    TouchImageView iv = view.findViewById(R.id.imageview);
                    dig.setView(view);

                    Glide.with(Objects.requireNonNull(context)).load(Uri.parse(data)).into(iv);
                    dig.show();
                }
            });
        }
    }
}