package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Product.MachineItem;
import kr.co.compcarecompany.R;

public class ReportPublishSettingAdapter extends RecyclerView.Adapter<ReportPublishSettingAdapter.ItemViewHolder> {

    Context context;

    private ArrayList<MachineItem> items = new ArrayList<>();

    public ReportPublishSettingAdapter(@NonNull Context context, ReportPublishSettingAdapter.completeListener completeListener) {
        this.context = context;
        this.completeListener = completeListener;
    }

    private ReportPublishSettingAdapter.completeListener completeListener;

    public interface completeListener {
        void yn_clickBtn(String mc_idx, String isChecked, int position);

        void period_clickBtn(String mc_idx, String period, int position);
    }


    @NonNull
    @Override
    public ReportPublishSettingAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        // 소비전력 레포트 발행
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_report_publish_setting, viewGroup, false);

        return new ReportPublishSettingAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ReportPublishSettingAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        itemViewHolder.publish_ynRG.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup radioGroup, int i) {
                RadioButton button = radioGroup.findViewById(i);
                switch (button.getText().toString()) {
                    case "ON":
                        completeListener.yn_clickBtn(items.get(position).getMcIdx(), "Y", position);
                        items.get(position).setRpYn("Y");
                        break;

                    case "OFF":
                        completeListener.yn_clickBtn(items.get(position).getMcIdx(), "N", position);
                        items.get(position).setRpYn("N");
                        break;
                }
            }
        });

        itemViewHolder.publish_periodRG.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup radioGroup, int i) {
                RadioButton button = radioGroup.findViewById(i);

                switch (button.getText().toString()) {
                    case "주간 (매주 월 발행)":
                        completeListener.period_clickBtn(items.get(position).getMcIdx(), "week", position);
                        items.get(position).setRpPeriod("week");
                        break;
                    case "월간 (매달 1일 발행)":
                        completeListener.period_clickBtn(items.get(position).getMcIdx(), "month", position);
                        items.get(position).setRpPeriod("month");
                        break;
                }
            }
        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<MachineItem> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView cp_nameTV, mc_airlineTV, mc_iot_macTV, mc_lotTV, mc_nameTV;
        RadioGroup publish_ynRG, publish_periodRG;
        RadioButton publish_nRBtn, publish_yRBtn, publish_weekRBtn, publish_monthRBtn;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            cp_nameTV = itemView.findViewById(R.id.cp_nameTV);
            mc_airlineTV = itemView.findViewById(R.id.mc_airlineTV);
            mc_iot_macTV = itemView.findViewById(R.id.mc_iot_macTV);
            mc_lotTV = itemView.findViewById(R.id.mc_lotTV);
            mc_nameTV = itemView.findViewById(R.id.mc_nameTV);
            publish_ynRG = itemView.findViewById(R.id.publish_ynRG);
            publish_periodRG = itemView.findViewById(R.id.publish_periodRG);
            publish_yRBtn = itemView.findViewById(R.id.publish_yRBtn);
            publish_nRBtn = itemView.findViewById(R.id.publish_nRBtn);
            publish_weekRBtn = itemView.findViewById(R.id.publish_weekRBtn);
            publish_monthRBtn = itemView.findViewById(R.id.publish_monthRBtn);

        }

        void onBind(MachineItem data) {

            cp_nameTV.setText(data.getCpName());
            mc_airlineTV.setText("[ " + data.getMcAirline() + " ]");
            mc_iot_macTV.setText("MAC ( " + data.getMcIotMac() + " )");
            if (data.getMcLot() != null) {
                mc_lotTV.setText("제품번호 ( " + data.getMcLot() + " )");
            }
            mc_nameTV.setText(data.getPdName());

            if (data.getRpYn() != null && data.getRpYn().equals("Y")) {
                publish_ynRG.check(publish_yRBtn.getId());
            } else {
                publish_ynRG.check(publish_nRBtn.getId());
            }

            if (data.getRpPeriod() != null && data.getRpPeriod().equals("week")) {
                publish_periodRG.check(publish_weekRBtn.getId());
            } else {
                publish_periodRG.check(publish_monthRBtn.getId());
            }

        }
    }
}


