package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Company.CompanyData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.MyOnItemClick;

public class ReportPublishSettingTabAdapter  extends RecyclerView.Adapter<ReportPublishSettingTabAdapter.ItemViewHolder> {

    Context context;
    Handler handler;
    MyOnItemClick callback;

    private ArrayList<CompanyData> items = new ArrayList<>();

    public ReportPublishSettingTabAdapter(@NonNull Context context, MyOnItemClick callback) {
        this.context = context;
        this.callback = callback;
    }

    @NonNull
    @Override
    public ReportPublishSettingTabAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_report_publish_tab, viewGroup, false);

        return new ReportPublishSettingTabAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ReportPublishSettingTabAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        if(items.get(position).isSelected()){

            itemViewHolder.cp_nameTV.setBackgroundResource(R.drawable.bg_line_bottom_purple_stroke2);
            itemViewHolder.cp_nameTV.setTextColor(context.getResources().getColor(R.color.color_bg_purple));

        } else {

            itemViewHolder.cp_nameTV.setBackgroundResource(R.color.white);
            itemViewHolder.cp_nameTV.setTextColor(context.getResources().getColor(R.color.dark_gray));
        }

        itemViewHolder.cp_nameTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Bundle bundle = new Bundle();
                bundle.putString("item_position", position+"");
                callback.onClick(bundle);
            }
        });

    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(CompanyData data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.add(data);
        notifyDataSetChanged();
    }

    public void addItems(ArrayList<CompanyData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
//        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView cp_nameTV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            cp_nameTV = itemView.findViewById(R.id.cp_nameTV);
        }

        void onBind(CompanyData data) {

            cp_nameTV.setText(data.getCpName());

        }
    }
}
