package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;
import java.util.HashMap;

import kr.co.compcarecompany.Data.Product.ProductData;
import kr.co.compcarecompany.R;

public class SearchMachineAdapter extends RecyclerView.Adapter<SearchMachineAdapter.ItemViewHolder> {

    Context context;
    Handler handler;

    private SearchMachineAdapter.clickListener clickListener;

    public interface clickListener {
        void clickBtn(HashMap<String, ProductData> data);
    }

    private ArrayList<ProductData> items = new ArrayList<>();

    public SearchMachineAdapter(@NonNull Context context, SearchMachineAdapter.clickListener clickListener) {
        this.context = context;
        this.clickListener = clickListener;
    }

    @NonNull
    @Override
    public SearchMachineAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_search_machine, viewGroup, false);

        return new SearchMachineAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull SearchMachineAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        itemViewHolder.item_search_machineLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                HashMap<String, ProductData> data = new HashMap<>();
                data.put("productData", items.get(position));
                clickListener.clickBtn(data);
            }
        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<ProductData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView item_search_machine_nameTV, item_search_machine_specTV, item_search_machine_buyerTV;
        LinearLayout item_search_machineLL;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            item_search_machine_buyerTV = itemView.findViewById(R.id.item_search_machine_buyerTV);
            item_search_machine_nameTV = itemView.findViewById(R.id.item_search_machine_nameTV);
            item_search_machine_specTV = itemView.findViewById(R.id.item_search_machine_specTV);
            item_search_machineLL = itemView.findViewById(R.id.item_search_machineLL);
        }

        void onBind(ProductData data) {

            if(data.getPdBuyer() != null && !data.getPdBuyer().equals("")){
                item_search_machine_buyerTV.setText("제조사 - "+data.getPdBuyer());

            } else {
                item_search_machine_buyerTV.setVisibility(View.GONE);
            }
            item_search_machine_nameTV.setText(data.getPdName());
            item_search_machine_specTV.setText(data.getPdSpec());
        }
    }
}

