package kr.co.compcarecompany.Util.Adapter;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcarecompany.Data.Company.WorkData;
import kr.co.compcarecompany.Data.Product.ReportData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class ServiceListAdapter extends RecyclerView.Adapter<ServiceListAdapter.ItemViewHolder> {

    Context context;
    Handler handler;

    private ServiceListAdapter.clickListener clickListener;

    public interface clickListener {
        void clickBtn(Bundle bundle);
    }

    private ServiceListAdapter.OnLoadMoreListener OnLoadMoreListener;

    public interface OnLoadMoreListener {
        void onLoadMore(int position);
    }


    private ArrayList<WorkData> items = new ArrayList<>();

    public ServiceListAdapter(@NonNull Context context, ServiceListAdapter.clickListener clickListener, ServiceListAdapter.OnLoadMoreListener OnLoadMoreListener) {
        this.context = context;
        this.clickListener = clickListener;
        this.OnLoadMoreListener = OnLoadMoreListener;
    }

    @NonNull
    @Override
    public ServiceListAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_service_list, viewGroup, false);
        return new ServiceListAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ServiceListAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        if (position == getItemCount() - 1) {
            if (OnLoadMoreListener != null) {
                OnLoadMoreListener.onLoadMore(position);
            }
        }

        itemViewHolder.item_serviceLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Bundle bundle = new Bundle();
                bundle.putString("wo_idx", items.get(position).getWoIdx());
                clickListener.clickBtn(bundle);
            }
        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<WorkData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void addItemMore(ArrayList<WorkData> lst) {
        items.addAll(lst);
        notifyItemRangeChanged(0, items.size());
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView item_service_nameTV, item_service_stateTV, item_service_dateTV, item_service_memoTV, item_service_workTV;
        LinearLayout item_serviceLL, item_service_contentLL;
        ImageView exist_invoiceIV;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            item_serviceLL = itemView.findViewById(R.id.item_serviceLL);

            item_service_nameTV = itemView.findViewById(R.id.item_service_nameTV);
            item_service_stateTV = itemView.findViewById(R.id.item_service_stateTV);
            item_service_dateTV = itemView.findViewById(R.id.item_service_dateTV);
            item_service_memoTV = itemView.findViewById(R.id.item_service_memoTV);
            item_service_workTV = itemView.findViewById(R.id.item_service_workTV);
            item_service_contentLL = itemView.findViewById(R.id.item_service_contentLL);
            exist_invoiceIV = itemView.findViewById(R.id.exist_invoiceIV);
        }

        void onBind(WorkData data) {

            item_service_nameTV.setText(data.getCpName());
            //M : 종료 C : 미결
            if (data.getWoStatus().equals("M")) {
                item_service_stateTV.setText("완료");
                item_service_stateTV.setTextColor(Color.parseColor("#9134A1"));
                item_service_stateTV.setBackgroundResource(R.drawable.border_purple_fill_white_round_30);
                item_service_contentLL.setVisibility(View.VISIBLE);

                if (data.getWrStatus().equals("D")) {
                    item_service_workTV.setText(Common.getInstance().isNullText(data.getWoWorkerName()) + " 기사 " + data.getWoSucdtStr() + " 조치완료");
                }

            } else if (data.getWoType().equals("IOT")) {
                item_service_stateTV.setText("기사 자동호출");
                item_service_stateTV.setTextColor(Color.WHITE);
                item_service_stateTV.setBackgroundResource(R.drawable.bg_round_purple_30);
                item_service_contentLL.setVisibility(View.GONE);

            } else {
                item_service_stateTV.setText("접수");
                item_service_stateTV.setTextColor(Color.WHITE);
                item_service_stateTV.setBackgroundResource(R.drawable.bg_round_purple_30);
                item_service_contentLL.setVisibility(View.GONE);
            }

            item_service_dateTV.setText(data.getInsDt());
            String memo = data.getWoMemo();
            String order;

            if (TextUtils.isEmpty(memo)) {
                memo = "";
            }

            if (data.getWoMemoOrders() == null) {
                order = "";

            } else {
                order = data.getWoMemoOrders().toString();
            }

            if (TextUtils.isEmpty(memo) && TextUtils.isEmpty(order)) {
                item_service_memoTV.setText("(접수내용 없음)");

            } else {
                item_service_memoTV.setText(memo + " " + order);
            }

            if(data.getInvoiceCnt() != null && Integer.parseInt(data.getInvoiceCnt()) > 0) {
                exist_invoiceIV.setVisibility(View.VISIBLE);
            }
        }
    }
}