package kr.co.compcarecompany.Util.Alarm;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.TaskStackBuilder;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.RingtoneManager;
import android.os.Build;

import androidx.core.app.NotificationCompat;

import java.text.ParseException;

import kr.co.compcarecompany.Activity.Intro;
import kr.co.compcarecompany.MyApplication;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class PublishWeekAlarmReceiver extends BroadcastReceiver {

    private Context context;
    private String channelId = "week_alarm";
    private int period_week = 7;
    private int week_id = 11117;

    Intent main_intent;

    @Override
    public void onReceive(Context context, Intent intent) {
        this.context = context;

        Common.getInstance().setPref(context, "week_report", true);

        main_intent = new Intent(context, Intro.class);
        main_intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);

        if (MyApplication.myActivity != null) {
            main_intent.putExtra("report_publish", "week");
        }

        setAlarmRepeat();
        sendNotification();
    }

    private void setAlarmRepeat() {

        if (Common.getInstance().getPref(context, "week_report_publish", true)) {
            Intent intent = new Intent(context, PublishWeekAlarmReceiver.class);
            PendingIntent alarmIntent = PendingIntent.getBroadcast(context, 7, intent, PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_IMMUTABLE);
            AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);

            try {
                AlarmManager.AlarmClockInfo ac = new AlarmManager.AlarmClockInfo(Common.getInstance().getTimeForAlarm("week"), alarmIntent);
                alarmManager.cancel(alarmIntent);
                alarmManager.setAlarmClock(ac, alarmIntent);
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendNotification() {

        TaskStackBuilder stackBuilder = TaskStackBuilder.create(context);
        stackBuilder.addNextIntentWithParentStack(main_intent);
        PendingIntent busRoutePendingIntent = stackBuilder.getPendingIntent(period_week, PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_IMMUTABLE);

        final NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context, channelId)
                .setSmallIcon(R.mipmap.launcher).setDefaults(Notification.DEFAULT_ALL)
                .setSound(RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION))
                .setAutoCancel(true)
                .setContentTitle("콤프케어")
                .setContentText("주간 소비전력 레포트가 발행되었습니다. 확인하시겠습니까?")
                .addAction(R.drawable.ic_sms, "확인", busRoutePendingIntent)
                .setContentIntent(busRoutePendingIntent);

        final NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel channel = new NotificationChannel(channelId, "Channel human readable title", NotificationManager.IMPORTANCE_DEFAULT);
            notificationManager.createNotificationChannel(channel);
        }

        notificationManager.notify(week_id, notificationBuilder.build());

    }
}