package kr.co.compcarecompany.Util.Alarm;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import java.text.ParseException;

import kr.co.compcarecompany.Util.Common;

public class RebootReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {

            AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);

            Intent week_intent = new Intent(context, PublishWeekAlarmReceiver.class);
            PendingIntent week_alarmIntent = PendingIntent.getBroadcast(context, 7, week_intent, PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_IMMUTABLE);
            alarmManager.cancel(week_alarmIntent);

            if (Common.getInstance().getPref(context, "week_report_publish", true)) {
                try {
                    AlarmManager.AlarmClockInfo ac = new AlarmManager.AlarmClockInfo(Common.getInstance().getTimeForAlarm("week"), week_alarmIntent);
                    alarmManager.cancel(week_alarmIntent);
                    alarmManager.setAlarmClock(ac, week_alarmIntent);
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }

            Intent month_intent = new Intent(context, PublishMonthAlarmReceiver.class);
            PendingIntent month_alarmIntent = PendingIntent.getBroadcast(context, 31, month_intent, PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_IMMUTABLE);
            alarmManager.cancel(month_alarmIntent);

            if (Common.getInstance().getPref(context, "month_report_publish", true)) {
                try {
                    AlarmManager.AlarmClockInfo ac = new AlarmManager.AlarmClockInfo(Common.getInstance().getTimeForAlarm("month"), month_alarmIntent);
                    alarmManager.cancel(month_alarmIntent);
                    alarmManager.setAlarmClock(ac, month_alarmIntent);
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

