package kr.co.compcarecompany.Util.CustomView;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.Log;
import android.widget.TextView;

import com.github.mikephil.charting.components.MarkerView;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IFillFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.utils.MPPointF;

import java.util.ArrayList;

import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class CustomMarkerView2 extends MarkerView {

    private TextView marker_valueTV, marker_dateTV;
    private ArrayList<String> time;

    public CustomMarkerView2(Context context, int layoutResource, ArrayList<String> time) {
        super(context, layoutResource);
        marker_valueTV = findViewById(R.id.marker_valueTV);
        marker_dateTV = findViewById(R.id.marker_dateTV);
        this.time = time;
    }

    @Override
    public void refreshContent(Entry e, Highlight highlight) {

        int index = (int) e.getX();

        if (e instanceof CandleEntry) {
            CandleEntry ce = (CandleEntry) e;
            String y = Common.getInstance().moneyFormatToWon((int) ce.getHigh());
            marker_valueTV.setText(y + "kW");
        } else {
            String y = Common.getInstance().moneyFormatToWon((int) e.getY());
            marker_valueTV.setText(y + "kW");
        }

        if (time.size() > 0) marker_dateTV.setText(time.get(index));
        super.refreshContent(e, highlight);
    }

    @Override
    public MPPointF getOffset() {
        return new MPPointF(-(getWidth() / 2), -getHeight());
    }

    @Override
    public void draw(Canvas canvas, float posX, float posY) {

        MPPointF offset = getOffset();
        int saveId = canvas.save();

        Paint paint = new Paint();
        paint.setColor(Color.RED);
        paint.setStrokeWidth(7f);
        canvas.drawCircle(posX, posY, 7f, paint);
        if (posY + offset.y < 0) {
            canvas.translate(posX + offset.x, -offset.y - posY);
        } else {
            canvas.translate(posX + offset.x, posY + offset.y);
        }
        draw(canvas);
        canvas.restoreToCount(saveId);
    }
}