package kr.co.compcarecompany.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import kr.co.compcarecompany.Data.ArrayItem;
import kr.co.compcarecompany.Data.Product.ExchangeData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Adapter.ExchangeLogAdapter;

public class ExchangeLogDialog extends Dialog {

    Context context;
    private TextView cp_nameTV, mc_airlineTV, pd_nameTV, closeTV;
    private RecyclerView exchange_log_listRV;
    private ArrayItem<ExchangeData> exchangeData;

    public ExchangeLogDialog(@NonNull Context context, ArrayItem<ExchangeData> exchangeData) {
        super(context);
        this.context = context;
        this.exchangeData = exchangeData;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_exchange_log);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        cp_nameTV = findViewById(R.id.cp_nameTV);
        mc_airlineTV = findViewById(R.id.mc_airlineTV);
        pd_nameTV = findViewById(R.id.pd_nameTV);
        exchange_log_listRV = findViewById(R.id.exchange_log_listRV);
        closeTV = findViewById(R.id.closeTV);

        init_Listener();
        set_contents();
    }

    void init_Listener() {

        //닫기버튼
        closeTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
    }

    void set_contents() {

        cp_nameTV.setText(exchangeData.get(0).getCpName());
        mc_airlineTV.setText(exchangeData.get(0).getMcAirline());
        pd_nameTV.setText(exchangeData.get(0).getPdName());
        ExchangeLogAdapter adapter = new ExchangeLogAdapter();
        exchange_log_listRV.setAdapter(adapter);
        adapter.addItem(exchangeData.getArrayitem());
    }
}

