package kr.co.compcarecompany.Util.CustomView;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

import kr.co.compcarecompany.Activity.FragmentActivity;
import kr.co.compcarecompany.Data.ArrayItem;
import kr.co.compcarecompany.Data.ArrayItem_;
import kr.co.compcarecompany.Data.FileDatum;
import kr.co.compcarecompany.Data.Product.AlarmData;
import kr.co.compcarecompany.Data.Product.AlarmReportData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Adapter.ReportAdapter;
import kr.co.compcarecompany.Util.Adapter.ReportImageAdapter;
import kr.co.compcarecompany.Util.Api.ApiClient;
import kr.co.compcarecompany.Util.Common;

public class MachineImageDialog extends Dialog {

    Context context;
    private RecyclerView machine_imageRV;
    private ReportImageAdapter photo_adapter;

    private ArrayList<FileDatum> photo_data;
    private ArrayList<String> photo_uri;
    private TextView closeTV;

    public MachineImageDialog(@NonNull Context context, ArrayList<FileDatum> photo_data) {
        super(context);
        this.context = context;
        this.photo_data = photo_data;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_machine_image);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        machine_imageRV = findViewById(R.id.machine_imageRV);
        closeTV = findViewById(R.id.closeTV);

        int px = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 6f, getContext().getResources().getDisplayMetrics());
        int itemHeight = x - (machine_imageRV.getPaddingLeft() + machine_imageRV.getPaddingRight() - px * 2) / 3;

        machine_imageRV.setLayoutManager(new GridLayoutManager(getContext(), 3));
        photo_adapter = new ReportImageAdapter(getContext(), itemHeight, "remove_none");
        machine_imageRV.setAdapter(photo_adapter);

        photo_uri = new ArrayList<>();
        String machine_uri = "https://www.compcare.co.kr/uploads/machine/";
        for (int i = 0; i < photo_data.size(); i++) {
            photo_uri.add(machine_uri + photo_data.get(i).getPfiFilename());
        }

        photo_adapter.addItem(photo_uri);

        init_Listener();
    }

    void init_Listener() {
        closeTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
    }
}
