package kr.co.compcarecompany.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Point;
import android.os.Bundle;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.NumberPicker;

import androidx.annotation.NonNull;

import java.util.Calendar;
import java.util.HashMap;

import kr.co.compcarecompany.R;

public class MyPickerDialog extends Dialog {

    private static final int MAX_YEAR = 2099;
    private static final int MIN_YEAR = 2020;

    public Calendar cal = Calendar.getInstance();

    public MyPickerDialog(@NonNull Context context) {
        super(context);
    }

    private MyPickerDialog.MyPickerDialogListener listener;

    public void setListener(MyPickerDialog.MyPickerDialogListener listener) {
        this.listener = listener;
    }

    public interface MyPickerDialogListener {
        void clickBtn(HashMap<String, Integer> data);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.dlg_datepicker);

        Button btnConfirm;
        Button btnCancel;
        String hour, min;
        String[] displayedValues = new String[]{"00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};

        final NumberPicker monthPicker = findViewById(R.id.picker_month);
        final NumberPicker yearPicker = findViewById(R.id.picker_year);
        final NumberPicker dayPicker = findViewById(R.id.picker_day);
        final NumberPicker timePicker = findViewById(R.id.picker_time);
        final NumberPicker minPicker = findViewById(R.id.picker_min);

        btnConfirm = findViewById(R.id.btn_confirm);
        btnCancel = findViewById(R.id.btn_cancel);

        btnCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
            }
        });

        String[] finalDisplayedValues = displayedValues;
        btnConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                HashMap<String, Integer> data = new HashMap();
                data.put("year", yearPicker.getValue());
                data.put("month", monthPicker.getValue());
                data.put("day", dayPicker.getValue());
                data.put("hour", timePicker.getValue());
                data.put("min", Integer.parseInt(finalDisplayedValues[minPicker.getValue()]));
                listener.clickBtn(data);
                dismiss();
            }
        });

        dayPicker.setMinValue(1);
        dayPicker.setMaxValue(31);
        dayPicker.setValue(cal.get(Calendar.DATE));

        monthPicker.setMinValue(1);
        monthPicker.setMaxValue(12);
        monthPicker.setValue(cal.get(Calendar.MONTH) + 1);

        int year = cal.get(Calendar.YEAR);
        yearPicker.setMinValue(MIN_YEAR);
        yearPicker.setMaxValue(MAX_YEAR);
        yearPicker.setValue(year);

        timePicker.setMinValue(0);
        timePicker.setMaxValue(23);
        hour = cal.getTime() + "";
        min = hour.substring(14, 16);
        hour = hour.substring(11, 13);
        timePicker.setValue(Integer.parseInt(hour));

        displayedValues = new String[]{"00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};

        minPicker.setMinValue(0);
        minPicker.setMaxValue(displayedValues.length-1);
        minPicker.setDisplayedValues(displayedValues);
        minPicker.setValue(Integer.parseInt(min) / 5);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.8f);
        int y = (int) (size.y * 0.4f);

        thisWindow.setLayout(x, y);
    }
}
