package kr.co.compcarecompany.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;

import androidx.annotation.NonNull;

import java.util.HashMap;

import kr.co.compcarecompany.R;

public class RelayProgressDialog extends Dialog {

    Context context;
    private String mac;
    private ImageView emergency_stopIV;

    private RelayProgressDialog.clickListener clickListener;

    public interface clickListener {
        void clickBtn();
    }

    public RelayProgressDialog(@NonNull Context context, String mac, RelayProgressDialog.clickListener clickListener) {
        super(context);
        this.context = context;
        this.mac = mac;
        this.clickListener = clickListener;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_custom_progress);
        setCancelable(false);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        emergency_stopIV = findViewById(R.id.emergency_stopIV);

        init_Listener();
    }

    void init_Listener() {

        emergency_stopIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clickListener.clickBtn();
                dismiss();
            }
        });
    }
}

