package kr.co.compcarecompany.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import androidx.annotation.NonNull;

import kr.co.compcarecompany.Data.ArrayItem;
import kr.co.compcarecompany.Data.Product.MonitoringData;
import kr.co.compcarecompany.Data.Product.RelayData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Common;

public class ScheduleDetailDialog extends Dialog {

    Context context;
    private TextView start_dayTV, start_timeTV, end_dayTV, end_timeTV, time_periodTV, schedule_memoTV, closeTV;
    private RelayData relayData;

    public ScheduleDetailDialog(@NonNull Context context, Handler hdr, RelayData relayData) {
        super(context);
        this.context = context;
        this.relayData = relayData;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_schedule_detail);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        start_dayTV = findViewById(R.id.start_dayTV);
        start_timeTV = findViewById(R.id.start_timeTV);
        end_dayTV = findViewById(R.id.end_dayTV);
        end_timeTV = findViewById(R.id.end_timeTV);
        time_periodTV = findViewById(R.id.time_periodTV);
        schedule_memoTV = findViewById(R.id.schedule_memoTV);
        closeTV = findViewById(R.id.closeTV);

        set_Contents();
        init_Listener();

    }

    void set_Contents() {

        int s_day = Integer.parseInt(relayData.getRsStartDay());
        int e_day = Integer.parseInt(relayData.getRsEndDay());
        int s_hour = Integer.parseInt(relayData.getRsStartTime().substring(0, 2));
        int s_min = Integer.parseInt(relayData.getRsStartTime().substring(3, 5));
        int e_hour = Integer.parseInt(relayData.getRsEndTime().substring(0, 2));
        int e_min = Integer.parseInt(relayData.getRsEndTime().substring(3, 5));

        set_day(s_day, start_dayTV);
        set_day(e_day, end_dayTV);
        set_time_period(s_day, e_day, s_hour, s_min, e_hour, e_min, time_periodTV);

        start_timeTV.setText(relayData.getRsStartTime());
        end_timeTV.setText(relayData.getRsEndTime());
        schedule_memoTV.setText(Common.getInstance().isNullText(relayData.getRsMemo()));
    }

    void init_Listener(){

        closeTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
    }

    void set_time_period(int s_day, int e_day, int s_hour, int s_min, int e_hour, int e_min, TextView textView) {
        int time_period;
        int time;
        int min;

        if (s_day < e_day) {
            time_period = (60 * ((e_day - s_day) * 24 + e_hour) + e_min) - (60 * s_hour + s_min);

        } else if (s_day == e_day) {
            time_period = (60 * e_hour + e_min) - (60 * s_hour + s_min);

        } else {
            time_period = (60 * ((7 - (s_day - e_day)) * 24 + e_hour) + e_min) - (60 * s_hour + s_min);
        }

        time = time_period / 60;
        min = time_period % 60;

        if (time == 0 && min > 0) {
            textView.setText(min + "분 가동");

        } else if (min == 0 && time > 0) {
            textView.setText(time + "시간 가동");

        } else {
            textView.setText(time + "시간 " + min + "분\n가동");
        }
    }

    void set_day(int day, TextView textView) {
        switch (day) {
            case 0:
                textView.setText("일");
                break;
            case 1:
                textView.setText("월");
                break;
            case 2:
                textView.setText("화");
                break;
            case 3:
                textView.setText("수");
                break;
            case 4:
                textView.setText("목");
                break;
            case 5:
                textView.setText("금");
                break;
            case 6:
                textView.setText("토");
                break;
        }
    }
}


