package kr.co.compcarecompany.Util.CustomView;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.Display;
import android.view.Window;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;

import kr.co.compcarecompany.R;

public class SearchAddressDialog extends Dialog {

    private WebView webView;
    private Handler handler;
    private FrameLayout mContainer;
//    private ProgressDialog dialog;

    private SearchAddressListener searchAddressListener;

    public interface SearchAddressListener {
        void clickBtn(HashMap<String, String> data);
    }

    public SearchAddressDialog(Context context, SearchAddressListener searchAddressListener) {
        super(context);
        this.searchAddressListener = searchAddressListener;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dlg_search_address);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.9f);
        int y = (int) (size.y * 0.9f);

        thisWindow.setLayout(x, y);

        mContainer = findViewById(R.id.mContainer);

        // WebView 초기화
        init_webView();

        // 핸들러를 통한 JavaScript 이벤트 반응
        handler = new Handler();
    }

    public void init_webView() {
        // WebView 설정
        webView = (WebView) findViewById(R.id.daum_webview);

        // JavaScript 허용
        webView.getSettings().setJavaScriptEnabled(true);

        // JavaScript의 window.open 허용
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);

        // JavaScript이벤트에 대응할 함수를 정의 한 클래스를 붙여줌
        webView.addJavascriptInterface(new AndroidBridge(), "TestApp");

        webView.loadUrl("https://www.compcare.co.kr/modules/api/views/procs/proc_search_address.php");

    }

    private class AndroidBridge {
        @JavascriptInterface
        public void setAddress(final String arg1, final String arg2, final String arg3) {
            handler.post(new Runnable() {
                @Override
                public void run() {

                    Location geo = null;

                    try {
                        geo = findGeoPoint(getContext(), arg2);
                    } catch (IOException e) {
                        e.printStackTrace();
                    }

                    HashMap<String, String> data = new HashMap();
                    data.put("zonecode", arg1);
                    data.put("Address", arg2);
                    data.put("buildingName", arg3);
                    data.put("lot", "" + geo.getLongitude());
                    data.put("lnt", "" + geo.getLatitude());

                    searchAddressListener.clickBtn(data);
                    dismiss();
                }
            });
        }
    }

    private static Location findGeoPoint(Context context, String address) throws IOException {

        Location loc = new Location("");
        Geocoder coder = new Geocoder(context);
        List<Address> addr = null;

        addr = coder.getFromLocationName(address, 5);

        if (addr != null) {
            for (int i = 0; i < addr.size(); i++) {
                Address lating = addr.get(i);
                // 위도가져오기
                double lat = lating.getLatitude();
                // 경도가져오기
                double lon = lating.getLongitude();
                loc.setLatitude(lat);
                loc.setLongitude(lon);
            }
        }
        return loc;
    }
}