package kr.co.compcarecompany.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.util.HashMap;

import kr.co.compcarecompany.Data.ArrayItem_;
import kr.co.compcarecompany.Data.Company.ServiceData;
import kr.co.compcarecompany.R;
import kr.co.compcarecompany.Util.Adapter.ServiceInvoiceAdapter;
import kr.co.compcarecompany.Util.Api.ApiClient;
import kr.co.compcarecompany.Util.Common;

public class ServiceDetailDialog extends Dialog {

    private Handler hdr;
    private String wo_idx;
    private TextView dlg_service_companyTV, dlg_service_memoTV, dlg_service_workerTV, dlg_service_dateTV, dlg_service_reportTV, dlg_service_closeTV, dlg_service_call_dateTV,
            dlg_service_photo_noneTV, dlg_service_report_photo_noneTV, dlg_service_invoice_noneTV;
    private RecyclerView dlg_service_photoRV, dlg_service_report_photoRV, dlg_service_invoice_listRV;
    private ArrayItem_<ServiceData> service_data;
    LinearLayout dlg_service_reportLL, dlg_service_invoice_existLL;
    ServiceImageGridAdapter photo_adapter, report_photo_adapter;
    ServiceInvoiceAdapter invoiceAdapter;


    public ServiceDetailDialog(@NonNull Context context, Handler hdr, String wo_idx) {
        super(context);
        this.hdr = hdr;
        this.wo_idx = wo_idx;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_service_detail);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        dlg_service_companyTV = findViewById(R.id.dlg_service_companyTV);
        dlg_service_memoTV = findViewById(R.id.dlg_service_memoTV);
        dlg_service_photoRV = findViewById(R.id.dlg_service_photoRV);
        dlg_service_workerTV = findViewById(R.id.dlg_service_workerTV);
        dlg_service_dateTV = findViewById(R.id.dlg_service_dateTV);
        dlg_service_reportTV = findViewById(R.id.dlg_service_reportTV);
        dlg_service_report_photoRV = findViewById(R.id.dlg_service_report_photoRV);
        dlg_service_closeTV = findViewById(R.id.dlg_service_closeTV);
        dlg_service_call_dateTV = findViewById(R.id.dlg_service_call_dateTV);
        dlg_service_reportLL = findViewById(R.id.dlg_service_reportLL);
        dlg_service_photo_noneTV = findViewById(R.id.dlg_service_photo_noneTV);
        dlg_service_report_photo_noneTV = findViewById(R.id.dlg_service_report_photo_noneTV);
        dlg_service_invoice_listRV = findViewById(R.id.dlg_service_invoice_listRV);
        dlg_service_invoice_existLL = findViewById(R.id.dlg_service_invoice_existLL);
        dlg_service_invoice_noneTV = findViewById(R.id.dlg_service_invoice_noneTV);

        int px = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 6f, getContext().getResources().getDisplayMetrics());
        int itemHeight = x - (dlg_service_photoRV.getPaddingLeft() + dlg_service_photoRV.getPaddingRight() - px * 4) / 5;

        dlg_service_photoRV.setLayoutManager(new GridLayoutManager(getContext(), 5));
        photo_adapter = new ServiceImageGridAdapter(getContext(), itemHeight);
        dlg_service_photoRV.setAdapter(photo_adapter);

        dlg_service_report_photoRV.setLayoutManager(new GridLayoutManager(getContext(), 5));
        report_photo_adapter = new ServiceImageGridAdapter(getContext(), itemHeight);
        dlg_service_report_photoRV.setAdapter(report_photo_adapter);

        invoiceAdapter = new ServiceInvoiceAdapter();
        dlg_service_invoice_listRV.setAdapter(invoiceAdapter);

        init_Handler();
        init_Listener();
        Get_Service_Data();
    }

    void Get_Service_Data() {

        HashMap<String, String> data = new HashMap<>();
        data.put("wo_idx", wo_idx);
        new ApiClient(data, "proc_admin_get_service", hdr);
    }

    void Set_Contents() {

        dlg_service_companyTV.setText(service_data.getArrayitem().getCpName());
        dlg_service_memoTV.setText(service_data.getArrayitem().getWoMemo());
        dlg_service_call_dateTV.setText(service_data.getArrayitem().getWoCalldtDay() + " " + service_data.getArrayitem().getWoCalldtTime());

        if (service_data.getArrayitem().getWoStatus().equals("M")) {
            dlg_service_reportLL.setVisibility(View.VISIBLE);
            dlg_service_dateTV.setText(service_data.getArrayitem().getWorkerData().get(0).getWrEnddtDay() + " " + service_data.getArrayitem().getWorkerData().get(0).getWrEnddtTime());

            if(service_data.getArrayitem().getWorkerData().get(0).getWrWorkerName2() != null && !service_data.getArrayitem().getWorkerData().get(0).getWrWorkerName2().equals("0")){
                dlg_service_workerTV.setText(service_data.getArrayitem().getWorkerData().get(0).getWrWorkerName2());

            } else if (service_data.getArrayitem().getWoWorkerName() != null){
                dlg_service_workerTV.setText(service_data.getArrayitem().getWoWorkerName());
            }

            String report = service_data.getArrayitem().getWorkerData().get(0).getWrMemoReport();
            String report_sub = service_data.getArrayitem().getWorkerData().get(0).getWrMemoReportSub();

            if (TextUtils.isEmpty(report) && !TextUtils.isEmpty(report_sub)) {
                dlg_service_reportTV.setText(report_sub);

            } else if (!TextUtils.isEmpty(report) && TextUtils.isEmpty(report_sub)) {
                dlg_service_reportTV.setText(report);

            } else if (!TextUtils.isEmpty(report) && !TextUtils.isEmpty(report_sub)) {
                dlg_service_reportTV.setText(report + " " + report_sub);

            }else {
                dlg_service_reportTV.setText("조치완료");
            }

        } else {
            dlg_service_reportLL.setVisibility(View.GONE);
        }
    }

    void init_Listener() {

        //닫기 버튼 클릭 리스너
        dlg_service_closeTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

    }

    void init_Handler() {

        hdr = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                String url = msg.getData().getString("url");

                if (msg.what == 1) {
                    if (url.equals("proc_admin_get_service")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        Log.d("가져왔다@@@@", result_item.toString());
                        service_data = new Gson().fromJson(result_item, new TypeToken<ArrayItem_<ServiceData>>() {
                        }.getType());

                        if (service_data.isSuccess()) {

                            if (service_data.getArrayitem().getFileDataBefore() != null && service_data.getArrayitem().getFileDataBefore().size() > 0) {
                                photo_adapter.addItem(service_data.getArrayitem().getFileDataBefore());
                                dlg_service_photoRV.setVisibility(View.VISIBLE);
                                dlg_service_photo_noneTV.setVisibility(View.GONE);

                            } else {
                                dlg_service_photoRV.setVisibility(View.GONE);
                                dlg_service_photo_noneTV.setVisibility(View.VISIBLE);
                            }

                            if (service_data.getArrayitem().getFileDataAfter() != null && service_data.getArrayitem().getFileDataAfter().size() > 0) {
                                report_photo_adapter.addItem(service_data.getArrayitem().getFileDataAfter().get(0).getItems());
                                dlg_service_report_photoRV.setVisibility(View.VISIBLE);
                                dlg_service_report_photo_noneTV.setVisibility(View.GONE);

                            } else {
                                dlg_service_report_photoRV.setVisibility(View.GONE);
                                dlg_service_report_photo_noneTV.setVisibility(View.VISIBLE);
                            }

                            if(service_data.getArrayitem().getInvoiceList() != null && service_data.getArrayitem().getInvoiceList().size() > 0){
                                invoiceAdapter.addItem(service_data.getArrayitem().getInvoiceList());
                                dlg_service_invoice_existLL.setVisibility(View.VISIBLE);
                                dlg_service_invoice_noneTV.setVisibility(View.GONE);
                            } else {
                                dlg_service_invoice_existLL.setVisibility(View.GONE);
                                dlg_service_invoice_noneTV.setVisibility(View.VISIBLE);
                            }

                            Set_Contents();

                        } else {
                            Common.getInstance().toastShow(getContext(), "서비스 정보 가져오기를 실패했습니다.");
                        }
                    }

                } else {
                    Toast.makeText(getContext(), msg.obj.toString(), Toast.LENGTH_SHORT).show();
                }
            }
        };
    }
}
