package kr.co.compcarecompany.Util.Firebase;

import android.util.Log;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;

import java.util.Map;

import kr.co.compcarecompany.Activity.MainActivity;
import kr.co.compcarecompany.Fragment.Main.Machine_Management_Fragment;
import kr.co.compcarecompany.MyApplication;
import kr.co.compcarecompany.Util.Common;
import kr.co.compcarecompany.Util.Service.AlarmThread;

public class MyFirebaseMessagingService extends FirebaseMessagingService {
    private static final String TAG = "MyFirebaseMsgService";
    public static MainActivity activity;
    public static Machine_Management_Fragment fragment;

    @Override
    public void onNewToken(String s) {
        super.onNewToken(s);
        Common.getInstance().setPref(getApplicationContext(), "token", s);
        Log.d("새로운 토큰@@@", s);
        sendRegistrationToServer(s);
    }

    private void sendRegistrationToServer(String token) {
        // TODO: Implement this method to send token to your app server.
    }

    // 메시지 수신
    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        Log.i(TAG, "onMessageReceived");
        Map<String, String> data = remoteMessage.getData();

        for (String key : data.keySet()) {
            Log.d(TAG, key + "(" + data.get(key) + ")");
        }
        String title = data.get("title");
        String cp_idx = data.get("cp_idx");
        String message = data.get("body");

        if (message.contains("서비스 접수")) {
            if (Common.getInstance().getPref(getApplicationContext(), "noti_x", true)) {
                return;
            } else {
                if (MyApplication.alarm_thread != null) {
                    MyApplication.alarm_thread.stopForever();
                    MyApplication.alarm_thread = null;
                }

                MyApplication.alarm_thread = new AlarmThread(getApplicationContext(), title, message, cp_idx);
                MyApplication.alarm_thread.start();
            }
        } else if (message.contains("소모품") || message.contains("주의 알람")) {
            if (Common.getInstance().getPref(getApplicationContext(), "alarm_noti_x", true)) {
                return;

            } else {
                if (!Common.getInstance().getPref(getApplicationContext(), cp_idx, true)) {
                    return;
                } else {
                    if (MyApplication.alarm_thread != null) {
                        MyApplication.alarm_thread.stopForever();
                        MyApplication.alarm_thread = null;
                    }

                    MyApplication.alarm_thread = new AlarmThread(getApplicationContext(), title, message, cp_idx);
                    MyApplication.alarm_thread.start();
                }
            }
        }

//        if (activity != null) {
//            activity.refresh();
//        }
//
//        if (fragment != null) {
//            fragment.refresh();
//        }
    }
}