<?php

class clib_model extends MY_Model
{
	public $cf;
	public $codea_arr = array();
	public $MemberID;
	public $lang;
	public $is_admin;
	public $config;

	protected $CI;
	private $member_group;

	public $tb = array(
		'codea' => 'tb_codea'
	, 'codeb' => 'tb_codeb'
	, 'codec' => 'tb_codec'
	, 'drink_use' => 'tb_drink_use'
	, 'pay' => 'tb_pay'
	, 'sms_check' => 'tb_sms_check'
	, 'user' => 'tb_member'
	, 'user_out' => 'cb_member_out'
	, 'auction' => 'cb_auction'
	, 'auction_item' => 'cb_auction_item_a'
	, 'auction_tender' => 'cb_auction_tender'
	, 'transport' => 'cb_transport'
	, 'deposit' => 'cb_deposit' /* 보증금 */
	, 'flatrate' => 'cb_flatrate' /* 정액제 */
	, 'holyday' => 'cb_holyday'/*공휴일*/
	);


	function __construct()
	{
		global $_SESSION;
		global $is_admin;
		global $config;

		parent::__construct();

		//하드코딩
		$cf = array();
		$cf['google_api_key'] = 'AIzaSyBu1YkyQd31k7aHUePR-JOrRlFk4nXccSI';//구글 api 지도 키
		$cf['navermap_key'] = 'add7ZJ2zjGvujEQ6rkoj';//네이버 지도 키

		$cf['kakao'] = array();
		$cf['kakao']['cid'] = 'TC0ONETIME';
		$cf['kakao']['admin_key'] = '7548ec39d8b936cd35baabe289d51b2b';

		//$cf['naver_blog_key'] = 'AAAAPMTfARc4WPd4FGB2vHvrngC4zh9ftVnBIeOpYoQCpvqwFXYsirkwx8KcOoi7EULjAxPTNjGQZRNFzHXb79cvWXk=';
		$cf['naver_refresh_token'] = 'V84ptthQEo8tPd9fxRLBipJFwqFKysHGXAR2tjBZripipweNtElxXqeTvDcWbStYJ45BaJBwzM50BK9kz0GzQ2CBklLWFXQmu60tFyFc2GisexTmXrCV3sg5jcln4KH1UwnC';

		$cf['all_comm'] = 'HYUNDAI,DONGK,DAEHAN,HANGUK,YKS,HANC,HYAN';//전체 제강사

		//200만원을 최초입금해야됨
		$cf['seller_deposit_first'] = 2000000;

		//두번째는 150만원
		$cf['seller_deposit_notfirst'] = 1500000;

		$cf['end_time'] = date('Y-m-d', strtotime('+ 1 day')) . ' 12:00:00';//재설정 되는시간

		//안심번호 biz 콜믹스
		$cf['safe_number']['bizId'] = 'smsnp00270';
		$cf['safe_number']['monthDay'] = date('md');
		$cf['safe_number']['key'] = '109eabd009bf0a12063d7733ad66b5eb81f51c46e3fbaab7953c7fd14fa39a41';
		$cf['safe_number']['secureCode'] = hash('sha256', $cf['safe_number']['bizId'] . $cf['safe_number']['monthDay'] . $cf['safe_number']['key']);
		//$cf['safe_number']['secureCode']='109eabd009bf0a12063d7733ad66b5eb81f51c46e3fbaab7953c7fd14fa39a41';


		//도착제한시간
		$cf['transport_time'] = array('05:00', '06:00', '07:00', '08:00', '09:00', '10:00'
		, '11:00', '12:00', '13:00', '14:00', '15:00', '16:00'
		, '17:00', '18:00', '19:00', '20:00', '21:00', '22:00', '23:00');

		//파일업로드설정
		$cf['fileview_cnt'] = 8;
		$cf['file_upload_size_member'] = 20000000;//6mb 1mb = 1,048,576
		$cf['file_upload_size_member_mb'] = ceil($cf['file_upload_size_member'] / 1048576);
		$cf['file_thumb_width'] = 300;//섬네일 가로

		$cf['file_path'] = array();
		$cf['file_path']['code'] = array();
		$cf['file_path']['code']['folder'] = 'code';
		$cf['file_path']['code']['path'] = '/uploads/' . $cf['file_path']['code']['folder'] . "/";
		$cf['file_path']['code']['root'] = base_url() . config_item('uploads_dir') . "/file/" . $cf['file_path']['code']['folder'] . "/";
		$cf['file_path']['code']['url'] = base_url() . $cf['file_path']['code']['folder'] . "/";


		$cf['upload_max_filesize'] = ini_get('upload_max_filesize');


		//년도 검색범위(관리자 검색에 사용됨)
		$cf['year_range_arr'] = array();
		$cf['year'] = date('Y');
		$cf['year_min'] = 2018;

		$cf['item_price'] = 29600;//상품금액

		//$cf['year_min']부터 $cf['year'] 까지를 배열로
		for ($myear = $cf['year']; $myear >= $cf['year_min']; $myear--){
			$cf['year_range_arr'][] = $myear;
		}

		//철근상차비용
		$cf['cargo_price'] = 70000;
		//적재야드 사용료
		$cf['yard_price'] = 30000;

		$this->cf = $cf;


		$this->CI =& get_instance();


		$this->is_admin = $is_admin;
		$this->config = $config;


	}

	//기초코드 조회(1차)
	//
	function base_codea($code_id = "", $idx = "")
	{

		$table = $this->tb['codea'];
		$table2 = $this->tb['codeb'];

		$sql_where = '';
		if ($code_id) $sql_where = " and cd_a='{$code_id}' ";
		if ($idx) $sql_where = " and idx='{$idx}' ";

		$sql = "select *
		,(select count(*) from {$table2} where {$table}.cd_a=cd_a) as cnt_b
		from {$table} where 1=1 /* del_flag='N'  */ {$sql_where} order by order_num ";

		$data = array();
		$result = $this->sql_query($sql);

		$i = 0;
		$arr = $result->result_array();
		foreach ($arr as $row){
			$data[$i] = $row;
			// 개발자 전용 항목

			/* if($this->MemberID != "dmonster") {
				if(isset($data[$i]['perm_write']) && $data[$i]['perm_write'] == "N") $data[$i]['perm_write_str'] = "alert('입력불가합니다.\\n개발사에 문의바랍니다.');return;";
				if(isset($data[$i]['perm_edit']) && $data[$i]['perm_edit'] == "N") $data[$i]['perm_edit_str'] = "alert('수정불가합니다.\\n개발사에 문의바랍니다.');return;";
				if(isset($data[$i]['perm_delete']) && $data[$i]['perm_delete'] == "N") $data[$i]['perm_delete_str'] = "alert('삭제불가합니다.\\n개발사에 문의바랍니다.');return;";
			} */

			$i++;
		}

		return $data;
	}

	//기초코드 조회(2차)
	//
	//@CodeID : 1차코드 ID
	//@CiDX   : 시퀀스 번호 or @Code
	function base_codeb($rdata = array())
	{
		$table = $this->tb['codeb'];
		$lang = $this->lang;


		$data = array();

		$return_type = (isset($rdata['return_type'])) ? $rdata['return_type'] : "num";

		if (!$rdata['idx'] && !$rdata['cd_b'] && !$rdata['cd_a']) return $data;


		if ($rdata['idx']) $sql_where = " and ( idx='{$rdata['idx']}' or cd_b='{$rdata['idx']}' )";
		if ($rdata['cd_b']) $sql_where .= " and cd_b='{$rdata['cd_b']}' ";
		if ($rdata['del_flag']) $sql_where .= " and del_flag='{$rdata['del_flag']}' ";
		if ($rdata['cd_a']) $sql_where .= "and cd_a='{$rdata['cd_a']}' ";

		$sql = "select *,
		(select count(*) from tb_codec where tb_codeb.cd_b=tb_codec.cd_b ) as cnt_c,
		IF(del_flag='N','Y','N') as del_flag_opp
		from {$table}
		where  0=0 {$sql_where} order by order_num,idx  ";

		$rs = $this->sql_query($sql);

		$i = 0;

		$arr = $rs->result_array();

		foreach ($arr as $rows){
			if ($return_type == 'code') $i = $rows['Code'];
			$data[$i] = $rows;

			// 개발자 전용 항목
			if ($this->MemberID != "dmonster"){
				if (isset($rows['perm_write']) && $rows['perm_write'] == "N") $rows['perm_write_str'] = "alert('입력불가합니다.\\n개발사에 문의바랍니다.');return;";
				if (isset($rows['perm_edit']) && $rows['perm_edit'] == "N") $rows['perm_edit_str'] = "alert('수정불가합니다.\\n개발사에 문의바랍니다.');return;";
				if (isset($rows['perm_delete']) && $rows['perm_delete'] == "N") $rows['perm_delete_str'] = "alert('삭제불가합니다.\\n개발사에 문의바랍니다.');return;";
			}

			if ($return_type == 'num') $i++;
		}

		return $data;
	}

	//기초코드 조회(3차)
	//
	//@cd_a:1차코드ID
	//@cd_b:2차코드ID
	//@seq : 시퀀스 번호 or @code
	//@lang : 다국어적용,영어(eng),중국어(cn)(include/top_proc.html 에서 설정)
	//@return_type : num=기존방식, code=code를 키값으로 해서 반환함...DB 반복 사용을 줄이기 위한처리.
	//
	function base_codec($cd_a = "", $cd_b, $idx = "", $del_flag = "", $return_type = "num", $cd_memo = "")
	{

		$table = $this->tb['codec'];
		$lang = $this->lang;

		if ($idx) $sql_where = " and ( idx='{$idx}' or cd_c='{$idx}' )";

		if ($del_flag) $sql_where .= " and del_flag='{$del_flag}' ";
		if ($cd_memo) $sql_where .= "and cd_memo='{$cd_memo}' ";

		$sql = "select *, IF(del_flag='N','Y','N') as del_flag_opp, IF(del_flag='N','btn_check.gif','btn_stop.gif') as del_flag2
		from {$table}
		where 1=1 ";
		if ($cd_a) $sql .= "and cd_a='{$cd_a}' ";
		$sql .= "and cd_b='{$cd_b}' {$sql_where}  order by order_num,idx ";

		$rs = $this->sql_query($sql);

		$data = array();

		if ($return_type == 'code'){
			$arr = $rs->result_array();

			foreach ($arr as $row){
				$data[$row['cd_c']] = $row;
			}
		}else{
			//$data = sql_fetch_all($rs);
			$i = 0;
			$arr = $rs->result_array();

			foreach ($arr as $row){
				if ($row['cd_img1'] && strpos($row['cd_img1'], site_url()) === false) $row['cd_img1'] = site_url($row['cd_img1']);
				$data[$i] = $row;
				$i++;
			}
		}

		return $data;
	}

	//codec를 자유쿼리하는 용도.
	function codec_fetch($sql_where, $sql_order = "")
	{

		if (!$sql_where) return array();

		if (!$sql_order) $sql_order = "order_num, idx";

		$sql = "select * from tb_codec
		where 1=1 {$sql_where}  order by {$sql_order} ";

		$rs = $this->sql_query($sql);

		$data = array();
		$arr = $rs->result_array();
		foreach ($arr as $row){
			$data[] = $row;
		}

		return $data;
	}


	//codec 목록을 셀렉트박스내 옵션으로 보여줌
	function codec_option($cd_b, $cd_c, $use_nodata = true)
	{

		$arr = $this->base_codec("", $cd_b, '', 'N');
		$new_arr = array();

		foreach ($arr as $k => $v){
			$new_arr[$v['cd_c']] = $v['cd_nm'];
		}

		$str = search_option($new_arr, $cd_c);

		if ($use_nodata) $str = "<option value=''>선택</option>" . $str;

		return $str;
	}

	function codec_radio($name = '', $cd_b, $cd_c, $is_required=false, $is_readonly = false)
	{

		$arr = $this->base_codec("", $cd_b, '', 'N');
		$new_arr = array();
		$str = '';

		$options = '';
		if($is_required){
			$options.= "required hname='{$is_required}' ";
		}
		if($is_readonly){
			$options.= "disabled ";
		}

		foreach ($arr as $k => $v){
			$new_arr[$v['cd_c']] = $v['cd_nm'];

			//$str.="<label><input type='radio' name='{$name}' class='form-control form-inline' value='".$v['cd_c']."'>".$v['cd_nm']."</label>&nbsp;&nbsp;";

			$checked = ($cd_c == $v['cd_c']) ? 'checked' : '';
			$str .= "
			<div class='form-check form-check-inline'>
			  <input class='form-check-input' type='radio' name='{$name}' id='{$name}_{$v['cd_c']}' value='" . $v['cd_c'] . "' {$checked} {$options} >
			  <label class='form-check-label' for='{$name}_{$v['cd_c']}'>" . $v['cd_nm'] . "</label>
			</div>\r\n";

		}

		//if($use_nodata) $str = "<label><input type='radio' name='{$name}' class='form-control form-inline' value=''>선택</label>";

		return $str;
	}


	/* 코드 b,c를 리턴 */
	function code_all($cd_a, $del_flag = 'N')
	{
		$arr = $this->base_codeb(array('cd_a' => $cd_a, 'del_flag' => $del_flag));


		$data = array();
		for ($i = 0; $i < count($arr); $i++){
			$row = $arr[$i];
			$row['count'] = $row['cnt_c'];
			$row['item'] = $this->base_codec($row['cd_a'], $row['cd_b'], "", $del_flag);
			$data[$i] = $row;
		}


		return $data;
	}




	/***************************
	 * 유저
	 ****************************/
	/*
	 * 유저정보 쿼리
	 * @convert:정보변환후 리턴할지 여부
	 */
	function user_fetch($sql_where = "", $sql_order = "", $sql_limit = "")
	{

		$table = $this->tb['user'];

		if (!$sql_order) $sql_order = "mb_idx desc ";
		if ($sql_limit) $sql_limit = "limit " . $sql_limit;

		$sql = "select * from {$table} where 1=1 {$sql_where}  order by {$sql_order} {$sql_limit}";

		$result = $this->sql_query($sql);

		$data = array();

		$i = 0;
		$arr = $result->result_array();
		foreach ($arr as $row){


			$data[$i] = $row;
			$i++;
		}

		return $data;
	}

	function get_user_no($mb_idx)
	{
		$table = $this->tb['user']; // 게시판 테이블 전체이름

		$sql_where = "and mb_idx='{$mb_idx}' ";

		$data = $this->user_list($sql_where, "", "1");

		return $data[0];
	}

	function get_user($mem_userid)
	{
		$table = $this->tb['user']; // 게시판 테이블 전체이름

		$sql_where = "and mb_id='{$mem_userid}' ";

		$data = $this->user_list($sql_where, "", "1");

		return $data[0];
	}

	/*
	 * 유저목록 컨버트된것.
	 */
	function user_list($sql_where = "", $sql_order = "", $sql_limit = "")
	{
		$data = $this->user_fetch($sql_where, $sql_order, $sql_limit);

		$ref = array();
		foreach ($data as $key => $arr){
			$ref[] = $this->user_convert($arr);
		}

		return $ref;
	}

	//public $data_buy_codec;
	//mb_level: 4 Agency master, 5~10 agency, 11~20 company
	// $is_partner = 파트너정보 pt_idx는 공장회원만 가지고있음.
	public function user_convert($row, $is_company=true, $is_filedata=true, $is_partner=false)
	{
		if (!is_array($row)) return $row;

		if ($row['mb_level'] > 10) $row['mb_user_type'] = 'member';
		else $row['mb_user_type'] = 'agency';

		//에이전시(대리점) 정보
		if ($is_company && $row['ag_idx']){
			$row['agency'] = array();
			if ($row['ag_idx']){
				if (!class_exists("Agency_model")) $this->CI->load->model('admin/Agency_model');
				$row['agency'] = $this->CI->Agency_model->get_agency($row['ag_idx']);
			}
		}

		//파트너(공장회원의 소속)정보
		if($is_partner && $row['pt_idx']){
			$row['partner'] = array();
			if(!class_exists('Partner_model')) $this->load->model('setting/Partner_model');
			$row['partner'] = $this->Partner_model->get_row($row['pt_idx']);
		}

		//회원구분
		$row['mb_type_str'] = '';
		if($row['mb_type']){
			$temp = $this->clib_model->base_codec('MEM', 'MBTY', $row['mb_type']);
			$row['mb_type_str'] = $temp[0]['cd_nm'];
		}


		//파일 로드
		if($is_filedata){
			$files = $this->CIFiles('', 'member', $row['mb_idx'], false);
			$row['photo1_data'] = $files;
			$row['photo1'] = $files[0]['pfi_filename'];
			$row['img_folder'] = 'member';
		}

		if($row['mb_outdt']=='0000-00-00') $row['mb_outdt'] ='';

		return $row;
	}


	/*
	 * 유저 그룹 체크
	 * 안씀
	 */

	function user_group_check($mem_userid = "")
	{

		if ($mem_userid){
			$where = array(
				'mem_id' => $mem_userid,
			);
			if (!class_exists("Member_group_member_model")) $this->CI->load->model('Member_group_member_model');
			$member_group = $this->CI->Member_group_member_model->get('', '', $where, '', 0, 'mgm_id', 'ASC');
		}else{
			//유저가 속한
			$member_group = $this->CI->member->group();
		}

		return $member_group;
	}


	/*파일업로드(ciborad)*/
	function CIUpload($files, $folder, $make_thum = false, $allowed_types = '')
	{
		if (!class_exists("upload")) $this->CI->load->library('upload');

		$ref = array('error' => 'true', 'msg' => '파일값이없습니다.', 'name' => '', 'ori' => '');

		if (isset($files) && isset($files['name']) && $files['name']){
			$upload_path = config_item('uploads_dir') . '/' . $folder . '/';
			if (is_dir($upload_path) === false){
				mkdir($upload_path, 0777);
				$file = $upload_path . 'index.php';
				$f = @fopen($file, 'w');
				@fwrite($f, '');
				@fclose($f);
				@chmod($file, 0777);
			}
			$upload_path .= cdate('Y') . '/';
			if (is_dir($upload_path) === false){
				mkdir($upload_path, 0777);
				$file = $upload_path . 'index.php';
				$f = @fopen($file, 'w');
				@fwrite($f, '');
				@fclose($f);
				@chmod($file, 0777);
			}
			$upload_path .= cdate('m') . '/';
			if (is_dir($upload_path) === false){
				mkdir($upload_path, 0777);
				$file = $upload_path . 'index.php';
				$f = @fopen($file, 'w');
				@fwrite($f, '');
				@fclose($f);
				@chmod($file, 0777);
			}

			$uploadconfig = '';
			$uploadconfig = config_item('uploadconfig');
			$uploadconfig['upload_path'] = $upload_path;
			if ($allowed_types != '') $uploadconfig['allowed_types'] = $allowed_types;
			//else $uploadconfig['allowed_types'] = 'jpg|jpeg|png|gif|pdf|avi|flv|mov|mkv|csv|mp3|mp4|zip|tar|rar|doc|ppt|pptx|docx|docm|dotx|dotm|xls|xla|xlt|xlw|odt|odp|ods|odc|odf|wp';
			/*$uploadconfig['max_size'] = $this->cf['file_upload_size_member'];
			$uploadconfig['max_width'] = '9999999';
			$uploadconfig['max_height'] = '99999999';
			$uploadconfig['encrypt_name'] = true;*/

			$this->CI->upload->initialize($uploadconfig);
			$_FILES['userfile']['name'] = $files['name'];
			$_FILES['userfile']['type'] = $files['type'];
			$_FILES['userfile']['tmp_name'] = $files['tmp_name'];
			$_FILES['userfile']['error'] = $files['error'];
			$_FILES['userfile']['size'] = $files['size'];
			if ($this->CI->upload->do_upload()){
				$filedata = $this->CI->upload->data();

/*				$uploadfiledata['nte_filename'] = cdate('Y') . '/' . cdate('m') . '/' . element('file_name', $filedata);
				$uploadfiledata['nte_originname'] = element('orig_name', $filedata);*/

				$uploadfiledata['pfi_filename'] = cdate('Y') . '/' . cdate('m') . '/' . element('file_name', $filedata);
				$uploadfiledata['pfi_originname'] = element('orig_name', $filedata);
				//$uploadfiledata['pfi_filesize'] = intval(element('file_size', $filedata) * 1024);//kb로 나온걸 Byte로 변경
				$uploadfiledata['pfi_filesize'] = intval(element('file_size', $filedata));
				$uploadfiledata['pfi_width'] = element('image_width', $filedata) ? element('image_width', $filedata) : 0;
				$uploadfiledata['pfi_height'] = element('image_height', $filedata) ? element('image_height', $filedata) : 0;
				$uploadfiledata['pfi_type'] = str_replace('.', '', element('file_ext', $filedata));
				$uploadfiledata['is_image'] = element('is_image', $filedata) ? element('is_image', $filedata) : 0;


				$ref['error'] = 'false';
				$ref['msg'] = '성공';
				$ref['name'] = $uploadfiledata['pfi_filename'];
				$ref['ori'] = $uploadfiledata['pfi_originname'];

				$ref['datas'] = $uploadfiledata;

			}else{
				$file_error = $this->CI->upload->display_errors("", "");

				$ref['error'] = 'true';
				$ref['msg'] = $file_error;
				$ref['name'] = '';
				$ref['ori'] = '';
				$ref['datas'] = array();
			}
		}

		return $ref;
	}



	/*
	 * 파일복사
	 * @ori: '2018/11/c86618045536039ddaa9c7a6191ce34d.jpg'
	 * @folder: 'product'
	 * @new_name = 'flower.jpg'
	 */
	function CICopy($ori, $folder='', $new_name='')
	{

		$ref = array('error' => 'true', 'msg' => '파일값이없습니다.', 'name' => '', 'ori' => '');

		if (!class_exists("upload")) $this->CI->load->library('upload');

		if ($ori){
			$upload_path = config_item('uploads_dir') . '/' . $folder . '/';
			if (is_dir($upload_path) === false){
				mkdir($upload_path, 0707);
				$file = $upload_path . 'index.php';
				$f = @fopen($file, 'w');
				@fwrite($f, '');
				@fclose($f);
				@chmod($file, 0644);
			}
			$upload_path .= cdate('Y') . '/';
			if (is_dir($upload_path) === false){
				mkdir($upload_path, 0707);
				$file = $upload_path . 'index.php';
				$f = @fopen($file, 'w');
				@fwrite($f, '');
				@fclose($f);
				@chmod($file, 0644);
			}
			$upload_path .= cdate('m') . '/';
			if (is_dir($upload_path) === false){
				mkdir($upload_path, 0707);
				$file = $upload_path . 'index.php';
				$f = @fopen($file, 'w');
				@fwrite($f, '');
				@fclose($f);
				@chmod($file, 0644);
			}

			$ori_name = basename($ori);
			$old_path_full = $_SERVER['DOCUMENT_ROOT'].'/'.config_item('uploads_dir').'/'.$folder.'/'.$ori;
			$old_path = str_replace($ori_name,'', $old_path_full);

			//파일명 생성
			if(!$new_name) $new_name = md5(uniqid(mt_rand())).file_extension($ori_name);

			$new_path = $_SERVER['DOCUMENT_ROOT'].'/'.$upload_path;
			$new_path_full = $new_path.'/'.$new_name;


			if (copy($old_path_full, $new_path_full)){
				$ref['error'] = 'false';
				$ref['msg'] = '성공';
				$ref['name'] = cdate('Y') . '/' . cdate('m').'/'.$new_name;
				$ref['ori'] = $ori;
			}else{
				$file_error = '실패했습니다.';

				$ref['error'] = 'true';
				$ref['msg'] = $file_error;
				$ref['name'] = '';
				$ref['ori'] = '';
			}
		}


		return $ref;
	}


	//파일목록
	/*
	 * @$pfi_idx: pk
	 * $datas
	 * @$table_type :연관테이블 이름(종류라고 보면됨)
	 * @post_id :연관테이블 key
	 * @mem_id: id
	 * @ag_idx = ag_idx
	 * @cp_idx = cp_idx
	 */
	function CIFiles($pfi_idx='', $table_type='', $post_id='', $get_one=false, $datas=array(), $post_id2=''){
		if (!class_exists("File_model")) $this->CI->load->model('File_model');

		//강제펄스
		$get_one= false;

		$where = array();
		if($pfi_idx) $where['pfi_idx'] = $pfi_idx;
		if($table_type) $where['table_type'] = $table_type;
		if($post_id) $where['post_id'] = $post_id;
		if($post_id2) $where['post_id2'] = $post_id2;

		if(is_array($datas) && count($datas)) array_merge($where, $datas);

		$data = $this->CI->File_model->get_list('', '', $where, '', 'pfi_order', 'ASC');
		$data = $data['list'];
		$cnt =count($data);
		if($cnt){
			for($x=0; $x<$cnt; $x++){
				$temp = $data[$x];
				$temp['url'] = base_url(config_item('uploads_dir').'/'.$table_type.'/'.$temp['pfi_filename']);
				$data[$x] = $temp;
			}
		}

		if($get_one) $data = $data[0];

		//널일때 foreach 에러방지
		if(!is_array($data)) $data = array();

		return $data;
	}


	/*
	 * 매달 1일 실행쿼리(구매정보등 초기화)
	 * cron
	 */
	function month_buyclear()
	{

		/* 유료회원이 아닌 회원은 등급까지 초기화 */
		$sql = "update " . $this->tb["user"] . "
				set mem_buy_cnt=0, mem_buy_price=0
				,mem_sell_cnt=0, mem_sell_price=0
				,mem_buy_lv='D', mem_sell_lv='D'
				,mem_buy_down=0, mem_sell_down=0
				,mem_sell_black_end='0000-00-00'
				,mem_buy_black_end='0000-00-00'
				where 1=1 and mem_use_yn='Y'
				and	(mem_payed_end < curdate() or mem_payed_start > curdate())
				and (mem_promo_end < curdate() or mem_promo_start > curdate()) ";//유료기간이 오늘보다 작으면 패밀리등급
		$this->sql_query($sql);

		//프로모션 회원은 거래실적만 초기화
		$sql = "update " . $this->tb["user"] . "
				set mem_buy_cnt=0, mem_buy_price=0
				,mem_sell_cnt=0, mem_sell_price=0
				,mem_buy_down=0, mem_sell_down=0
				where 1=1 and mem_use_yn='Y'
				and (
					(mem_payed_end >= curdate() and mem_payed_start <= curdate())
					OR
					(mem_promo_end >= curdate() and mem_promo_start <= curdate())
				) ";//유료기간이 오늘보다 커도 패밀리등급
		$this->sql_query($sql);
	}


	/*
	 * 매일 유료회원이 무료회원으로 변경 되었을때(무료기간 종료) 유저 등급 재설정
	 * 관리자가 프로모션등으로 지정했을경우만 존재하는 회원이다
	 */
	function day_buyclear()
	{

		$mem_userid_arr = array();

		//기간이 지난 유료회원을 검색
		$sql = "select mem_userid from " . $this->tb["user"] . " where
				mem_month_payed!='N' and mem_payed_end<>'0000-00-00' and mem_payed_end < curdate()
				and mem_denied=0 ";
		$result = $this->sql_query($sql);
		$data = $this->sql_fetch_all($result);

		//print_r2($data);

		foreach ($data as $i => $arr){
			$mem_userid = $arr['mem_userid'];
			$mem_userid_arr[] = $mem_userid;

			//유료결제정보 초기화
			$sql = "update " . $this->tb["user"] . " set mem_month_payed='N' where mem_userid='{$mem_userid}'	";
			$this->sql_query($sql);
		}

		//기간이 지난 프로모션회원을 검색
		$sql = "select mem_userid from " . $this->tb["user"] . " where 1=1
				and mem_denied=0
				and mem_promo_end<>'0000-00-00' and mem_promo_end < curdate()
				and (mem_promo_buy_lv!='N' OR mem_promo_sell_lv!='N')	";
		$result = $this->sql_query($sql);
		$data = $this->sql_fetch_all($result);

		foreach ($data as $i => $arr){
			$mem_userid = $arr['mem_userid'];
			$mem_userid_arr[] = $mem_userid;

			//유료결제정보 초기화
			$sql = "update " . $this->tb["user"] . " set mem_promo_buy_lv='N', mem_promo_sell_lv='N' where mem_userid='{$mem_userid}' ";
			$this->sql_query($sql);
		}

		$mem_userid_arr = array_unique($mem_userid_arr);
		foreach ($mem_userid_arr as $mem_userid){
			//등급 재계산
			$this->user_lv_update($mem_userid);
		}

	}


	/*
	 * 매출현황
	 * @type:search, today, yesterday, lastmonth, thismonth, thisyear, total
	 */
	function sales_total($type = "", $sdate = "", $edate = "")
	{

		switch ($type){
			case "today":
				$sdate = cdate('Y-m-d');
				$edate = cdate('Y-m-d');
				break;

			case "yesterday":
				$time = strtotime('-1 days');
				$sdate = cdate('Y-m-d', $time);
				$edate = cdate('Y-m-d', $time);
				break;

			case "lastmonth":
				$time = strtotime('-1 month');
				$sdate = cdate('Y-m', $time) . '-01';
				$edate = cdate('Y-m-t', $time);
				break;

			case "thismonth":
				$time = time();
				$sdate = cdate('Y-m', $time) . '-01';
				$edate = cdate('Y-m-t', $time);
				break;


			case "lastyear":
				$time = strtotime('-1 year');
				$sdate = cdate('Y', $time) . '-01-01';
				$edate = cdate('Y', $time) . '-12-31';
				break;

			case "thisyear":
				$time = time();
				$sdate = cdate('Y', $time) . '-01-01';
				$edate = cdate('Y', $time) . '-12-31';
				break;

			case "search":

			default:

				break;
		}


		$sql_where = "and ins_dt>'{$sdate} 00:00:00' and ins_dt<'{$edate} 59:59:59' ";

		if ($type == 'total') $sql_where = '';

		$sql = "select count(order_id) as `cnt`
		,ifnull(sum(weight_tot),0) as `weight_tot`
		,ifnull(sum(price),0) as `price`
		,ifnull(sum(susu_price),0) as `susu_price`
		from {$this->clib_model->tb['auction']} where 1=1 /* and ifnull(suc_bid,'')!='' and dep_status='Y' and del_flag='N'  */
		and status='E'
		{$sql_where} ";

		$row = $this->sql_fetch($sql);

		return $row;

	}


	/*파일업로드 (그누보드5) */
	/*
	 * @files : $_FILES[이름] 으로받는 배열값
	 * @paths : 파일이 저장될 경로 ex) $paths = "/data/code/"라면 code 만 입력;
	 * @$make_thum : 섬네일 생성여부
	 * */
	function FileUploadName($files, $folder, $make_thum = false)
	{
		$cf = $this->cf;
		$is_admin = $this->is_admin;
		$config = $this->config;


		$up_path = G5_DATA_PATH . '/file/' . $folder;

		if (!is_dir($up_path)){
			@mkdir($up_path, G5_DIR_PERMISSION);
			@chmod($up_path, G5_DIR_PERMISSION);
		}

		$tmp_file = $files['tmp_name'];
		$filesize = $files['size'];
		$filename = $files['name'];
		$filename = get_safe_filename($filename);//특문제거

		$upload = array();
		$upload['ok'] = 'false';
		$upload['msg'] = '실패했습니다.';

		$upload['file'] = '';
		$upload['source'] = '';//오리지널
		$upload['filesize'] = 0;
		$upload['image'] = array();
		$upload['image'][0] = '';
		$upload['image'][1] = '';
		$upload['image'][2] = '';
		$upload['img_thumb'] = '';

		//continue문을 사용하기위해 묶음
		do{
			// 서버에 설정된 값보다 큰파일을 업로드 한다면
			if ($filename){
				if ($files['error'] == 1){
					$upload['msg'] = '\"' . $filename . '\" 파일의 용량이 서버에 설정(' . $cf['upload_max_filesize'] . ')된 값보다 크므로 업로드 할 수 없습니다.\\n';
					continue;
				}else if ($files['error'] != 0){
					$upload['msg'] = '\"' . $filename . '\" 파일이 정상적으로 업로드 되지 않았습니다.\\n';
					continue;
				}

				if (is_uploaded_file($tmp_file)){
					// 관리자가 아니면서 설정한 업로드 사이즈보다 크다면 건너뜀
					if (!$is_admin && $filesize > $cf['file_upload_size_member']){
						$upload['msg'] .= '\"' . $filename . '\" 파일의 용량(' . number_format($filesize) . ' 바이트)이 게시판에 설정(' . number_format($cf['file_upload_size_member']) . ' 바이트)된 값보다 크므로 업로드 하지 않습니다.\\n';
						continue;
					}

					//=================================================================\
					// 090714
					// 이미지나 플래시 파일에 악성코드를 심어 업로드 하는 경우를 방지
					// 에러메세지는 출력하지 않는다.
					//-----------------------------------------------------------------
					$timg = @getimagesize($tmp_file);
					// image type
					if (preg_match("/\.({$config['cf_image_extension']})$/i", $filename) ||
						preg_match("/\.({$config['cf_flash_extension']})$/i", $filename)){
						if ($timg['2'] < 1 || $timg['2'] > 16)
							continue;
					}
					//=================================================================


					$upload['image'] = $timg;


					// 프로그램 원래 파일명
					$upload['source'] = $filename;
					$upload['filesize'] = $filesize;

					// 아래의 문자열이 들어간 파일은 -x 를 붙여서 웹경로를 알더라도 실행을 하지 못하도록 함
					$filename = preg_replace("/\.(php|phtm|htm|cgi|pl|exe|jsp|asp|inc)/i", "$0-x", $filename);


					// 첨부파일 첨부시 첨부파일명에 공백이 포함되어 있으면 일부 PC에서 보이지 않거나 다운로드 되지 않는 현상이 있습니다. (길상여의 님 090925)
					$upload['file'] = getUniqueFileName($filename);

					$dest_file = $up_path . '/' . $upload['file'];

					// 업로드가 안된다면 에러메세지 출력하고 죽어버립니다.
					$sucess_flag = move_uploaded_file($tmp_file, $dest_file) or die(false);

					// 썸네일 생성
					if ($sucess_flag){
						$upload['msg'] = '성공했습니다.';
						$upload['ok'] = "true";


						if ($make_thum){
							//var_dump(function_exists("thumbnail"));
							$thumb_file = thumbnail($upload['file'], $up_path, $up_path, $thumb_width = $cf['file_thumb_width'], $thumb_height = 0, true, false);
							$upload['img_thumb'] = $thumb_file;
						}

						// 올라간 파일의 퍼미션을 변경합니다.
						chmod($dest_file, G5_FILE_PERMISSION);
					}

					if (!get_magic_quotes_gpc()) $upload['source'] = addslashes($upload['source']);

				}else{
					$upload['msg'] = '업로드가 불가능합니다.';
				}
			}
		}while (false);

		return $upload;

	}

	//섬네일 파일명 리턴
	function getThumName($file_name)
	{
		if (!$file_name) return $file_name;

		$temp = explode('.', $file_name);
		$ref = 'thumb-' . $temp[0] . "_300x0." . $temp[1];

		return $ref;
	}

	//섬네일 파일명을 받아서 오리지날 파일명 리턴
	function getOriName($file_name)
	{
		if (!$file_name) return $file_name;

		$temp = explode('.', $file_name);
		$str = $temp[0];
		$str = str_replace('thumb-', '', $str);
		$str = str_replace('_300x0', '', $str);

		$ref = $str . "." . $temp[1];

		return $ref;
	}

	//게시판 목록(쿼리만)
	function board_fetch($bo_table, $sql_where = "", $sql_order = "", $sql_limit = "")
	{
		global $g5;

		$write_table = $g5['write_prefix'] . $bo_table; // 게시판 테이블 전체이름

		$sql = "select * from {$write_table} where 1=1 {$sql_where} {$sql_order} ";
		if ($sql_limit) $sql .= " order by {$sql_limit} ";
		else $sql .= " order by wr_num, wr_datetime ";
		$result = sql_query($sql);

		return sql_fetch_all($result);
	}

	//게시판 목록
	function board_list($bo_table, $sql_where = "", $sql_order = "", $sql_limit = "")
	{
		global $board, $g5, $board_skin_url;

		if (!count($board)) $board = sql_fetch(" select * from {$g5['board_table']} where bo_table='{$bo_table}' ");

		$write_table = $g5['write_prefix'] . $bo_table; // 게시판 테이블 전체이름

		$sql = "select * from {$write_table} where 1=1 {$sql_where} ";
		if ($sql_order) $sql .= " order by {$sql_order} ";
		else $sql .= " order by wr_num, wr_datetime ";

		if ($sql_limit) $sql .= "limit {$sql_limit} ";
		$rs = sql_query($sql);

		$data = array();

		$len = G5_IS_MOBILE ? $board['bo_mobile_subject_len'] : $board['bo_subject_len'];

		$i = 0;
		while ($row = sql_fetch_array($rs)){
			$row = get_view($row, $board, $board_skin_url, $len);

			if ($row['file']['count']){
				$row['file_thum'] = get_list_thumbnail2($board['bo_table'], $row['wr_id'], $board['bo_gallery_width'], $board['bo_gallery_height'], false, true);
			}

			$data[$i] = $row;
			$i++;
		}

		return $data;
	}


	/**********
	 * JSON 관련
	 **********/

	function jsonResult($method, $result, $message, $datas = "")
	{
		$result_json = array(
			"method" => (string)$method,
			"ok" => (string)$result,
			"msg" => (string)$message,
			"datas" => $datas,
		);
		$this->toJson($result_json);
		exit;
	}

	//성공
	function jsonResultSuccess($method, $message = "", $datas = array())
	{
		if ($message == "") $message = "성공했습니다.";
		return $this->jsonResult($method, "Y", $message, $datas);
	}

	//실패
	function jsonResultError($method, $message = "", $datas = array())
	{
		if ($message == "") $message = "잘못된 방법입니다.";
		return $this->jsonResult($method, "N", $message, $datas);
	}

	function toJson($result_array)
	{
		//echo my_json_encode($result_json);
		echo json_encode($result_array, JSON_UNESCAPED_UNICODE);
	}

	function getJson($result_array)
	{
		return json_encode($result_array, JSON_UNESCAPED_UNICODE);
	}

	function my_json_encode($arr)
	{
		array_walk_recursive(
			$arr,
			function (&$item, $key){
				if (is_string($item))
					$item = mb_encode_numericentity($item, array(0x80, 0xffff, 0, 0xffff), 'UTF-8');
			}
		);

		return mb_decode_numericentity(json_encode($arr), array(0x80, 0xffff, 0, 0xffff), 'UTF-8');
	}


	//휴대폰인증번호 발생목록
	function check_phone_fetch($sql_where, $sql_order = "", $sql_limit = "")
	{
		$table = $this->tb['sms_check'];

		if (!$sql_order) $sql_order = " start_dt desc ";

		$sql = "select * from {$table} where 1=1 {$sql_where}  order by {$sql_order} ";
		if ($sql_limit) $sql .= "limit {$sql_limit} ";

		$result = sql_query($sql);

		$data = array();

		$i = 0;
		while ($row = sql_fetch_array($result)){
			$data[$i] = $row;
			$i++;
		}

		return $data;
	}

	//드링크 사용등록
	function check_phone_insert($rdata = array())
	{
		$table = $this->tb['sms_check'];

		$phone = str_replace("/[^0-9]/", "", $rdata['phone']);
		$rand_num = $rdata['rand_num'];

		$start_dt = date('Y-m-d H:i:s');
		$end_dt = date('Y-m-d H:i:s', strtotime('+5 minutes'));

		$sql = "insert {$table} set phone='{$phone}'
		, start_dt='{$start_dt}'
		, end_dt='{$end_dt}'
		, check_number='{$rand_num}' ";

		$result = sql_query($sql);

		$ref['ok'] = 'false';
		$ref['data'] = null;
		if ($result){
			$ref['ok'] = 'true';
			$ref['data'] = $rand_num;
		}

		return $ref;
	}


	/*
	 * 가상번호 리스트
	 * @selGbn:조회구분(1:전체, 2:사용중인 번호리스트, 3:미사용 번호 리스트, 4:사용처)
	 * @seqNo:일련번호(현재 리스트의 마지막 행 번호입력 시 다음 페이지 리스트 출력 (페이징용))
	 * @reqCnt:Max 1000건, 지정이 없을 경우 디폴트는 100건
	 * @brNm:4번일 경우 필수 입력 ( 사용 처는 키워드 like검색 )
	 */
	function safe_number_list($selGbn = '3', $seqNo = 0, $reqCnt = 5, $brNm = '')
	{

		$headers = array(
			'Content-Type: application/x-www-form-urlencoded;charset=utf-8'
		);

		$fields = array();
		$fields['secureCode'] = $this->cf['safe_number']['secureCode'];
		$fields['bizId'] = $this->cf['safe_number']['bizId'];
		$fields['monthDay'] = $this->cf['safe_number']['monthDay'];
		$fields['selGbn'] = $selGbn;
		$fields['seqNo'] = $seqNo;
		$fields['reqCnt'] = $reqCnt;
		$fields['brNm'] = $brNm;

		//print_r2($fields);
		$param = http_build_query($fields);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://bizapi.callmix.co.kr/biz050/BZV100');
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $param);

		$result = curl_exec($ch);
		curl_close($ch);

		$res = json_decode($result, true);

		return $res;
	}

	/*
	 * 가상번호 매핑, 취소
	 * @tkGbn: 1:가상번호 매핑 , 2: 가상번호 취소 ( 결번 처리)
	 * @rn: 실번호:가상번호에 매핑 될 실 번호( 1588 , 1566 등의 대표번호는 처리불가 )
	 * @vn: 가상번호는 현재 타번호에 매핑이 되어 있어도 무조건 갱신 처리 됨
	 * @brNm: 사용처
	 */
	function safe_number_onoff($tkGbn = '1', $rn = '', $vn = '', $brNm = '')
	{

		$headers = array(
			'Content-Type: application/x-www-form-urlencoded;charset=utf-8'
		);

		$fields = array();
		$fields['secureCode'] = $this->cf['safe_number']['secureCode'];
		$fields['bizId'] = $this->cf['safe_number']['bizId'];
		$fields['monthDay'] = $this->cf['safe_number']['monthDay'];
		$fields['tkGbn'] = $tkGbn;
		$fields['rn'] = $rn;
		$fields['vn'] = $vn;
		$fields['brNm'] = $brNm;

		//print_r2($fields);
		$param = http_build_query($fields);

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://bizapi.callmix.co.kr/biz050/BZV210');
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $param);

		$result = curl_exec($ch);
		curl_close($ch);

		$res = json_decode($result, true);

		return $res;
	}



	/*
	 * 금액테이블
	 */
	function price_table($gu)
	{
		$ref = array();

		if (!$gu) return $ref;

		$this->CI->load->model('price_table');

		$ref = $this->CI->price_table->get_list($limit = '1', $offset = '0', $where = array('gu' => $gu));

		return $ref;
	}


	/**
	 * 로그인시 아이디와 패스워드가 일치하는지 체크합니다
	 */
	function _check_id_pw($password, $userid)
	{
		if (!function_exists('password_hash')){
			$this->CI->load->helper('password');
		}

		$ref = array('ok' => 'false', 'msg' => '잘못된 방법입니다.');

		
		$use_login_account = false;

		//$this->CI->load->model(array('Member_dormant_model'));

		$userselect = 'mb_idx, mb_password, mb_denied';
		$is_dormant_member = false;
		if ($use_login_account === 'both'){
			$userinfo = $this->CI->Member_model->get_by_both($userid, $userselect);

		}elseif ($use_login_account === 'email'){
			$userinfo = $this->CI->Member_model->get_by_email($userid, $userselect);

		}else{
			$userinfo = $this->CI->Member_model->get_by_userid($userid, $userselect);

		}

		$hash = password_hash($password, PASSWORD_BCRYPT);

		if (!element('mb_idx', $userinfo) OR !element('mb_password', $userinfo)){
			$ref['msg'] = '회원 아이디와 패스워드가 서로 맞지 않습니다';
			$this->CI->member->update_login_log(0, $userid, 0, '회원 아이디가 존재하지 않습니다');

			return $ref;
		}elseif (!password_verify($password, element('mb_password', $userinfo))){
			$ref['msg'] = '회원 아이디와 패스워드가 서로 맞지 않습니다';
			$this->CI->member->update_login_log(element('mb_idx', $userinfo), $userid, 0, '패스워드가 올바르지 않습니다');

			return $ref;
		}elseif (element('mb_denied', $userinfo)=='Y'){
			$ref['msg'] = '회원님의 아이디는 접근이 금지된 아이디입니다';
			$this->CI->member->update_login_log(element('mb_idx', $userinfo), $userid, 0, '접근이 금지된 아이디입니다');
			return $ref;
		}




		$ref['msg'] = '성공';
		$ref['ok'] = 'true';

		return $ref;
	}


	//유저 사용처리
	function member_use_ok($mb_idx = "", $mem_userid = "")
	{
		if (!$mb_idx && !$mem_userid) return;

		if (!class_exists("Member_model")) $this->CI->load->model('Member_model');

		$member = false;
		if ($mem_userid){
			$member = $this->CI->Member_model->get_by_userid($mem_userid, 'mb_idx, mem_nickname, mem_phone, mem_use_yn');
			$mb_idx = $member['mb_idx'];
		}else if ($mb_idx){
			$member = $this->CI->Member_model->get_by_memid($mb_idx, 'mb_idx, mem_nickname, mem_phone, mem_use_yn');
		}

		if ($member['mem_use_yn'] == 'Y') return false;

		$check = $this->CI->Member_model->update(''
			, array('mem_use_yn' => 'Y')
			, array('mb_idx' => $mb_idx, 'mem_use_yn' => 'N'));

		if ($check){
			$list = array('mb_idx' => $member['mb_idx'], 'name' => $member['mem_nickname'], 'phone' => get_phone($member['mem_phone'], 0));
			$this->sms_send($list, $msg = '아이디가 승인 되었습니다. 자유롭게 경매를 이용해보세요.');
		}

		//var_dump($check);
		return $check;
	}


	//제조사
	function maker_list($sql_where = "", $sql_order = "", $sql_limit = "")
	{
		if (!class_exists("Maker_model")) $this->CI->load->model('admin/Maker_model');

		if (!$sql_where) $sql_where = "and del_flag='N' ";
		if (!$sql_order) $sql_order = "ins_dt desc";

		$sql_where = '1=1 ' . $sql_where;
		$data = $this->CI->Maker_model->get_list('', '', $sql_where);

		return $data;
	}


	//다음코드 오토로 얻어냄
	//@ 테이블명, 필드명CIUpload
	//@
	function auto_next_code($table, $field, $where=''){

		$this->_table = $table;
		$data = $this->get('', $field, $where, 1, 0, $field, 'DESC');

		$code = $data[0][$field];
		if(!$code) $code = '1';
		else $code = (int)$code + 1;

		$fullcode = cdate('ymd').$code;

		//print_r2($data);
		echo $fullcode;
		return $fullcode;

		/*$sql = "SELECT {$field} FROM {$table} order by {$field} desc limit 1 ";
		$query = $this->db->query($sql);
		$row = $query->row_array();*/
		//$data = $this->get('', $this->primary_key, '', 1, 0, $this->primary_key, 'DESC');

		//print_r2($data);
	}



	//총갯수
	function get_total($TableName, $sql_where = "")
	{
		$sql = "select count(*) as `cnt` from {$TableName} where 1=1 {$sql_where}";
		$rs = $this->sql_fetch($sql);

		return $rs['cnt'];
	}


	//@mode:list, view, write
	//@brd_idx
	function board_auth_check($mode='', $brd_idx=''){
		$ref = array('ok'=>'true', 'msg'=>'잘못된 방법입니다.', 'level'=>'22');
		if($mode || !$brd_idx) return $ref;

		return $ref;
	}

	//디스크 체크(거래처별 사용량 업데이트)
	function disk_check($ag_idx=''){
		if (!class_exists("File_model")) $this->CI->load->model('File_model');
		//if (!class_exists("Partner_model")) $this->CI->load->model('setting/Partner_model');
        if (!class_exists("Agency_model")) $this->CI->load->model('admin/Agency_model');

		$sql_where = '';
		if($ag_idx) $sql_where.= "and ag_idx='{$ag_idx}' ";
		//if($pt_idx) $sql_where.= "and pt_idx='{$pt_idx}' ";

		/*$sql = "SELECT pt_idx, COUNT(pfi_idx) AS `cnt` , SUM(pfi_filesize) AS `size` FROM tb_file WHERE pt_idx IS NOT NULL {$sql_where} GROUP BY pt_idx ";*/

        $sql = "SELECT ag_idx, COUNT(pfi_idx) AS `cnt` , SUM(pfi_filesize) AS `size` FROM tb_file WHERE ag_idx IS NOT NULL {$sql_where} GROUP BY ag_idx ";

		$result = $this->sql_query($sql);
		$data = $result->result_array();

		$cnt = count($data);

		for($i=0; $i<$cnt; $i++){
			$row = $data[$i];
			$this->CI->Agency_model->update($row['ag_idx'], array('ag_disk_use'=>$row['size']));//사용량 업데이트
		}

		return $cnt;
	}

	//디스크 최대용량 체크(거래처별 최대치 업데이트)
	function disk_max_check($pt_idx){
//		if (!class_exists("Partner_model")) $this->CI->load->model('setting/Partner_model');
//		if (!class_exists("Qrcode_model")) $this->CI->load->model('admin/Qrcode_model');

		/*$sql_where = '';
		if($pt_idx) $sql_where.= "and pt_idx='{$pt_idx}' ";

		$sql = "SELECT pt_idx, COUNT(qr_idx) AS `cnt` , SUM(qr_disk_size) AS `size` FROM tb_qrcode WHERE pt_idx IS NOT NULL  {$sql_where} GROUP BY pt_idx ";
		$result = $this->sql_query($sql);
		$data = $result->result_array();

		$cnt = count($data);

		for($i=0; $i<$cnt; $i++){
			$row = $data[$i];
			$this->CI->Partner_model->update($row['pt_idx'], array('pt_disk_max'=>$row['size']));//사용량 업데이트
		}*/

		return true;
	}

	//디스크 용량 체크(사용가능한지)
	function get_disk_using($ag_idx){
		//if (!class_exists("Partner_model")) $this->CI->load->model('setting/Partner_model');

		$ref = array('ok'=>'false', 'msg'=>'', 'data'=>array());

		//대리점의 맥스치
        //$row['pt_disk_max'] = $this->member->item('ag_disk_max');

//		$sql = "SELECT pt_idx, pt_disk_use, pt_disk_max FROM tb_partner WHERE pt_idx='{$pt_idx}' ";
//		$result = $this->sql_query($sql);
//		$row = $result->row_array();

		// 3기가
        //$row['ag_disk_max'] = 3145728;

        if($ag_idx){
            if (!class_exists("Agency_model")) $this->CI->load->model('admin/Agency_model');
            $row = $this->Agency_model->get_one($ag_idx, 'ag_disk_max');
		}
        else{
            $row['ag_disk_max'] = 3145728;
		}


		if($row['ag_disk_max']=='0' || !$row['ag_disk_max']){
			$ref['msg'] = '사용가능한 용량이 설정되어 있지 않습니다.';
		}else if($row['ag_disk_use'] >= $row['ag_disk_max']){
			$ref['msg'] = '사용가능한 용량이 남아있지 않습니다.';
		}else{
			$ref['ok'] = 'true';
			$ref['msg'] = '업로드 할 수 있습니다.';
		}

		return $ref;
	}

	function traffic_check($ag_idx=''){

		/*$this->CI->config->config['base_url'] = str_replace('http://', 'https://', $this->CI->config->config['base_url']);
		//echo $this->CI->config->config['base_url'];
		echo base_url($this->CI->uri->uri_string());*/
		/*$this->CI->config->config['base_url'] = 'https://agency.compcare.co.kr';
		echo $this->CI->config->config['base_url'];*/

		$where = array();

		$rResult = getCurl("http://".config_item('site_name_last')."/cband-status?xml", false);

		//var_dump($rResult);
		//$sResult = simplexml_load_string($rResult);
		$xml = simplexml_load_string($rResult);
		$json = json_encode($xml);
		$xml = json_decode($json,TRUE);

		//print_r2($xml);

		if(!class_exists('Agency_model')) $this->CI->load->model('admin/Agency_model');
		if(!class_exists('Traffic_model')) $this->CI->load->model('Traffic_model');

		$where = array();
		if($ag_idx) $where['ag_idx'] = $ag_idx;

		$agency_data = $this->CI->Agency_model->get_list('', '', $where, '');

		for($i=0, $cnt=count($agency_data['list']); $i<$cnt; $i++){
			$row = $agency_data['list'][$i];
			$head = $row['mb_id'];

			if(!$row['mb_id']) continue;

			$site_name = $head.'.'.config_item('site_name_last');

			if(count($xml['Virtualhosts'])){
				$data = $xml['Virtualhosts'];

				if(isset($data[$site_name]) && count($data[$site_name])){
					$sites =$data[$site_name];
					#print_r2($sites);
					$total = get_number($sites['usages']['total']);

					$traffic_data = $this->CI->Traffic_model->get_today($row['ag_idx']);
					$tra_idx = $traffic_data['tra_idx'];

					$updatedata = array('ag_traffic'=>$total);

					if($tra_idx){
						$updatedata['edit_dt'] = cdate('Y-m-d H:i:s');
						$this->CI->Traffic_model->update($tra_idx, $updatedata);
					}else{
						$updatedata['ag_idx'] = $row['ag_idx'];
						$updatedata['ag_mb_id'] = $row['mb_id'];
						$updatedata['date_ym'] = cdate('Y-m');
						$updatedata['date_ymd'] = cdate('Y-m-d');
						$updatedata['ins_dt'] = cdate('Y-m-d H:i:s');
						$this->CI->Traffic_model->insert($updatedata);
					}
				}
			}
		}

	}

	//로그인 한 회원의 호스트네임 설정해서 리다이렉트
	function redirect_host(){
		$CI =& get_instance();

		if($CI->member->is_member()){
			$agency_data = $CI->member->item('agency');
			if(!$agency_data['mb_id']) return;

			$check_url = $agency_data['mb_id'].'.'.config_item('site_name_last');

			$CI->config->config['base_url'] = 'https://'.$check_url;
			if($_SERVER['HTTP_HOST']!=$agency_data['mb_id'].'.compcare.co.kr'){
				redirect($CI->uri->uri_string());
			}
		}
	}
	
		
	function make_code($type='', $ag_idx){

		if($type=='invoice'){

			$field = 'iv_code';
			$model_name = 'Invoice_model';
			$code_head = "IV";
		}else if($type==''){

		}

		if(!$ag_idx) $ag_idx = $this->member->item('ag_idx');

		$where = array('ag_idx'=>$ag_idx);
		$data = $this->{$model_name}->get('', $field, $where, 1, 0, $field, 'DESC');

		$code = $data[0][$field];
		if(!$code) $code = '1';
		else{
			$code = substr($data[0][$field], 2,6);
			$code = (int)$code + 1;
		}

		$code = sprintf('%06d', $code);

		$fullcode = $code_head.$code;

		return $fullcode;
	}
	
/////////////////////////
// 푸시알림 API 시작  25.03.05
/////////////////////////

	/**
	 * OAuth 토큰 가져오기
	 * 
	 * Firebase Cloud Messaging HTTP v1 API 사용을 위한 OAuth 토큰을 생성합니다.
	 * 서비스 계정 키 파일을 사용하여 JWT를 생성하고 Google OAuth 서버에서 액세스 토큰을 요청합니다.
	 * 
	 * @return string|boolean 성공 시 OAuth 액세스 토큰, 실패 시 false
	 */
	private function get_oauth_token() {
		$service_account_file = APPPATH . '../compcareadmin-firebase-adminsdk-6ebhn-7c69aab0ba.json';
		
		if (!file_exists($service_account_file)) {
			return false;
		}
		
		// 서비스 계정 키 파일 읽기
		$service_account = json_decode(file_get_contents($service_account_file), true);
		
		// 필수 필드 확인
		if (!isset($service_account['private_key']) || !isset($service_account['client_email'])) {
			return false;
		}
		
		// JWT 헤더 생성
		$header = [
			'alg' => 'RS256',
			'typ' => 'JWT'
		];
		
		// 현재 시간과 만료 시간 설정 (1시간)
		$now = time();
		$exp = $now + 3600;
		
		// JWT 클레임 생성
		$claims = [
			'iss' => $service_account['client_email'],
			'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
			'aud' => 'https://oauth2.googleapis.com/token',
			'exp' => $exp,
			'iat' => $now
		];
		
		// JWT 인코딩
		$base64_header = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode(json_encode($header)));
		$base64_claims = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode(json_encode($claims)));
		
		$jwt_unsigned = $base64_header . '.' . $base64_claims;
		
		// JWT 서명
		$private_key = $service_account['private_key'];
		openssl_sign(
			$jwt_unsigned,
			$signature,
			$private_key,
			'SHA256'
		);
		
		$base64_signature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
		
		// 완성된 JWT
		$jwt = $jwt_unsigned . '.' . $base64_signature;
		
		// OAuth 토큰 요청
		$ch = curl_init('https://oauth2.googleapis.com/token');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
			'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
			'assertion' => $jwt
		]));
		
		$response = curl_exec($ch);
		curl_close($ch);
		
		$token_data = json_decode($response, true);
		
		// 액세스 토큰 반환
		if (isset($token_data['access_token'])) {
			return $token_data['access_token'];
		}
		
		return false;
	}

	/**
	 * 푸시 알림 전송 함수
	 * 
	 * Firebase Cloud Messaging HTTP v1 API를 사용하여 푸시 알림을 전송합니다.
	 * 개별 또는 여러 사용자에게 알림을 보낼 수 있으며, 이미지와 클릭 액션을 포함할 수 있습니다.
	 * 
	 * @param string|array $mem_fcm_key 수신자 FCM 토큰 (단일 문자열 또는 배열)
	 * @param string $msg 알림 내용
	 * @param string $title 알림 제목
	 * @param string $send_type 전송 유형 (individual, broadcast, test 등)
	 * @param string $image_url 알림에 표시할 이미지 URL (선택사항)
	 * @param string $click_action 알림 클릭 시 이동할 URL (선택사항)
	 * @return array 전송 결과 정보
	 */
	function push_send($mem_fcm_key, $msg = "", $title = "", $send_type='', $image_url = "", $click_action = "")
	{
		// 프로젝트 ID 설정
		$PROJECT_ID = 'compcareadmin';
		
		// 결과 배열 초기화
		$ref = array();
		$ref['result'] = 'error';
		$ref['msg'] = '';
		$ref['push_result'] = array();
		$ref['push_error_msg'] = '';
		
		// FCM 토큰이 없는 경우 처리
		if (!$mem_fcm_key) {
			$ref['msg'] = 'FCM 토큰이 없습니다.';
			return $ref;
		}
		
		// 토큰을 배열로 변환
		if (!is_array($mem_fcm_key)) {
			$mem_fcm_key = array($mem_fcm_key);
		}
		
		// 중복 토큰 제거 및 빈 토큰 필터링
		$mem_fcm_key = array_unique($mem_fcm_key);
		$mem_fcm_key = array_filter($mem_fcm_key);
		
		// 토큰이 없는 경우 처리
		if (count($mem_fcm_key) == 0) {
			$ref['msg'] = '유효한 FCM 토큰이 없습니다.';
			return $ref;
		}
		
		// OAuth 토큰 가져오기
		$oauth_token = $this->get_oauth_token();
		
		// 헤더 설정
		$headers = array();
		if ($oauth_token) {
			// OAuth 인증 사용
			$headers[] = 'Authorization: Bearer ' . $oauth_token;
			$headers[] = 'Content-Type: application/json';
		} else {
			// 레거시 서버 키 인증 사용 (OAuth 실패 시 폴백)
			$headers[] = 'Authorization: key=AAAA-Wd_Ztg:APA91bGKxRhsLRNWJJbBjZQtm4nLxuBdMepv-xFBFXKYJYXwbBJLXYlVBNOJyFmYWJxX3EZQQtZY-_LrJQWRgNRrB-zEkJgxqCVmQVNebKWxNZJzGHYbIkxlXLQoNKqzDwHbz9SXnOZA';
			$headers[] = 'Content-Type: application/json';
		}
		
		// 성공 및 실패 카운트 초기화
		$success_count = 0;
		$fail_count = 0;
		$results = array();
		
		// 각 토큰에 대해 메시지 전송
		foreach ($mem_fcm_key as $token) {
			// 메시지 데이터 구성
			$message = array(
				'message' => array(
					'token' => $token,
					'notification' => array(
						'title' => $title,
						'body' => $msg
					),
					'data' => array(
						'title' => $title,
						'message' => $msg,
						'send_type' => $send_type
					)
				)
			);
			
			// 이미지 URL이 있는 경우 추가
			if ($image_url) {
				$message['message']['notification']['image'] = $image_url;
				$message['message']['data']['image_url'] = $image_url;
			}
			
			// 클릭 액션 URL이 있는 경우 추가
			if ($click_action) {
				$message['message']['data']['click_action'] = $click_action;
			}
			
			// Android 특정 설정
			$message['message']['android'] = array(
				'priority' => 'high',
				'notification' => array(
					'sound' => 'default'
				)
			);
			
			// iOS 특정 설정
			$message['message']['apns'] = array(
				'headers' => array(
					'apns-priority' => '10'
				),
				'payload' => array(
					'aps' => array(
						'sound' => 'default',
						'badge' => 1
					)
				)
			);
			
			// cURL 초기화
			$ch = curl_init();
			
			// cURL 옵션 설정
			curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/{$PROJECT_ID}/messages:send");
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($message));
			
			// 요청 실행
			$result = curl_exec($ch);
			$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			
			// cURL 종료
			curl_close($ch);
			
			// 결과 처리
			$result_data = json_decode($result, true);
			
			if ($http_status == 200) {
				$success_count++;
				$results[] = array(
					'token' => $token,
					'success' => true,
					'message_id' => isset($result_data['name']) ? $result_data['name'] : ''
				);
			} else {
				$fail_count++;
				$error_message = isset($result_data['error']['message']) ? $result_data['error']['message'] : '알 수 없는 오류';
				$results[] = array(
					'token' => $token,
					'success' => false,
					'error' => $error_message
				);
				$ref['push_error_msg'] .= $error_message . '; ';
			}
		}
		
		// 최종 결과 설정
		$ref['push_result'] = $results;
		
		if ($success_count > 0) {
			$ref['result'] = 'success';
			$ref['msg'] = "총 {$success_count}개의 알림이 성공적으로 전송되었습니다.";
			if ($fail_count > 0) {
				$ref['msg'] .= " ({$fail_count}개 실패)";
			}
		} else {
			$ref['msg'] = "알림 전송에 실패했습니다.";
		}
		
		// 푸시 알림 기록 저장
		$history_data = array(
			'push_type' => $send_type,
			'push_title' => $title,
			'push_message' => $msg,
			'push_image' => $image_url,
			'push_click_action' => $click_action,
			'push_tokens' => json_encode($mem_fcm_key),
			'push_result' => json_encode($ref['push_result'], JSON_UNESCAPED_UNICODE),
			'push_error_msg' => $ref['push_error_msg'],
			'ins_dt' => cdate('Y-m-d H:i:s')
		);
		$this->Push_model->insert($history_data);
		
		return $ref;
	}


  // 1. 기사 APP 기계고장알림 푸시발송 API
	// 2. "주의 또는 기계고장" 푸시알림 API (공장 APP)
	function push_control_care_check($pt_idx="", $msg="", $cp_idx="", $image_url="", $click_action="")
	{
        $ref = array(
            'push_send'=>false,
            'push_error_msg'=>'',
            'push_target'=>array(),
            'push_result'=>array()
        );

        $userinfo_data = $this->CI->clib_model->user_fetch("and pt_idx='{$pt_idx}' ");

        if(count($userinfo_data))
        {

            if($msg)
			 			{
                $mb_fcm_key_all = array();

                for($i=0; $i<count($userinfo_data); $i++)
								{
                    $userinfo = $userinfo_data[$i];

                    if($userinfo['mb_fcm_key'] && $userinfo['mb_fcm_yn']=='Y')
											{
                        $mb_fcm_key = explode(',', $userinfo['mb_fcm_key']);

                        array_push($mb_fcm_key_all, $mb_fcm_key);
                        array_unique($mb_fcm_key_all);
                  	  }
                }

                $result = array();
                for($i=0; $i<count($mb_fcm_key_all);$i++)
								{
                    $new_fcm = $mb_fcm_key_all[$i];
                    $title = '콤프케어';
                    
                    // HTTP v1 API를 사용하여 푸시 알림 전송
                    $result[$i] = $this->push_send($new_fcm, $msg, $title, 'care_check', $image_url, $click_action);
                }

                $ref['push_target'] =  $mb_fcm_key_all;

                if(count($mb_fcm_key_all))
								{
                    $ref['push_result'] = $result;
                    $ref['push_send'] = true;
                }
            }

        }
				else $ref['push_error_msg']='대상 번호가 없습니다.';
        
        return $ref;
  }

	// 3. "주의 또는 기계고장" 푸시알림 API (기사 APP)
	function push_control_care_check_for_eng ($ag_idx="", $msg="", $image_url="", $click_action="")
	{

        $ref = array(
            'push_send'=>false,
            'push_error_msg'=>'',
            'push_target'=>array(),
            'push_result'=>array()
        );

        $userinfo_data = $this->CI->clib_model->user_fetch("and ag_idx='{$ag_idx}' and mb_type <> 'COMPANY' ");

        if(count($userinfo_data))
        {

            if($msg)
						{
                $mb_fcm_key_all = array();

                for($i=0; $i<count($userinfo_data); $i++)
								{
                    $userinfo = $userinfo_data[$i];

                    if($userinfo['mb_fcm_key'] && $userinfo['mb_fcm_yn']=='Y')
										{
                        $mb_fcm_key = explode(',', $userinfo['mb_fcm_key']);

                        array_push($mb_fcm_key_all, $mb_fcm_key);
                        array_unique($mb_fcm_key_all);
                    }
                }

                $result = array();
                for($i=0; $i<count($mb_fcm_key_all);$i++)
								{
                    $new_fcm = $mb_fcm_key_all[$i];
                    $title = '콤프케어';
                    
                    // HTTP v1 API를 사용하여 푸시 알림 전송
                    $result[$i] = $this->push_send($new_fcm, $msg, $title, 'care_check_eng', $image_url, $click_action);
				        }

				            $ref['push_target'] =  $mb_fcm_key_all;

                if(count($mb_fcm_key_all))
								{
                    $ref['push_result'] = $result;
                    $ref['push_send'] = true;
                }
            }

        }
				else $ref['push_error_msg']='대상 번호가 없습니다.';
  }
  
  //푸시알림 끝


}  // clib_model class end...


//박건호 커스텀 라이브러리
//$clib = new clib();
if (!function_exists('getCurl')){
	function getCurl($fUrl, $is_post, $post_data=array())
	{

		$ch = curl_init($fUrl);

		curl_setopt($ch, CURLOPT_HTTPHEADER, array('application/x-www-form-urlencoded'));
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, $is_post);
		if ($is_post) curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
		$result = curl_exec($ch);

		curl_close($ch);
		return $result;
	}
}


if (!function_exists('error_msg')){
	// 에러 메세지 함수
	function error_msg($msg = "", $url = "", $relodad_url = "")
	{
		global $cf, $tmp_layer_id;

		if (!$msg) $msg = "정상적인 방법으로 이용해 주십시오.";

		$url = str_replace("&amp;", "&", $url);

		echo "<meta http-equiv='content-type' content='text/html; charset=utf-8'>";

		if (!$url) $url = "history.go(-1)";
		elseif ($url == "2") $url = "history.go(-2)";
		elseif ($url == "close") $url = "window.close()";
		elseif ($url == "end") $url = "";
		elseif ($url == "script"){
			echo "<script type='text/javascript'>{$msg}</script>";
			exit;
		}elseif (preg_match("/^javascript:/i", $url)) $url = str_replace("javascript:", "", $url);
		elseif ($url == 'dialog') $url = "parent.to_dialog.close()";
		elseif ($url == 'reload') $url = "location.reload()";
		elseif ($url == 'parent_reload') $url = "parent.location.reload()";
		// 2020-06-29 :: 출장판매 등록 후 바로 완료처리 실행시 오류현상 개선
		elseif ($url == 'parent_reload_url') $url = "parent.location.replace('$relodad_url')";
		else $url = "location.replace('$url')";

		if ($msg != "no_alert") echo "<script type='text/javascript'>alert('$msg');</script>";
		if ($url) echo "<script type='text/javascript'>$url;</script>";
		exit;
	}




}

if (!function_exists('alert_msg')){
	// 경고 메세지 함수
	function alert_msg($msg)
	{
		echo "<meta http-equiv='content-type' content='text/html; charset=utf-8'>";
		echo "<script type='text/javascript'>alert('$msg');</script>";
	}
}

if (!function_exists('movepage')){
	// 페이지 이동 스크립트 (header("location:URL") 을 대체)
	function movepage($url, $where = "")
	{
		if ($where && !preg_match("/\.$/", $where)) $where = $where . ".";

		$url = str_replace("&amp;", "&", $url);

		//echo"<meta http-equiv='refresh' content='0; url=$url'>";
		//echo "<script type='text/javascript'>location.href='$url';</script>";
		echo "<script type='text/javascript'>{$where}location.replace('$url');</script>";
		exit;
	}
}

//관리자용 사용중/비사용  jquery ui 아이콘
// @flag = 'Y', 'N',
// @rev = y, n값 반전
function del_flag_icon($flag, $rev = false)
{
	if ($flag == 'N') $cls = "ui-icon-check";
	else $cls = "ui-icon-cancel";

	$html = "<span class='ui-icon {$cls}'></span>";
	echo $html;
}


// 파일 업로드 함수
//
// 정의 : $file_name = FileUploadName("이전파일","저장경로","저장될 파일 전체이름","저장될 순수 파일이름");
// 예제 : $file_name = FileUploadName("","../../imgdata/",$user_file,$user_file_name);
//

//@files: $_FILES['이름'] 으로 받는 배열 값;


function FileUploadName($prev_file, $savedir, $file, $file_name, $prefix = "")
{
	// 폴더 생성 (20090820 )
	if (!is_dir($savedir)){
		@mkdir($savedir, 0777);
		@chmod($savedir, 0777);
	}

	// 등록파일이 있을 경우 처리 (20090820 )
	if ($file_name){

		// 이전파일 삭제
		if ($prev_file && $prev_file != "no"){
			if (file_exists($savedir . $prev_file)){
				@unlink($savedir . $prev_file);
			}
		}

		//특수문자등 제거
		$file_name = get_safe_filename($file_name);

		// $type 과 상관없이 임의의 파일명 생성 (20090917 )
		$file_name = getUniqueFileName($file_name, $prefix);

		// 절대 올리수 없도록 하는 확장자들 체크
		if (preg_match("/\.(php|phps|phtm|htm|html|shtm|ztx|dot|cgi|pl|exe|bat|jsp|asp|inc)$/i", $file_name)){
			echo "<script type='text/javascript'>
			      alert('HTML, PHP 관련파일은 업로드할 수 없습니다.');
				  history.go(-1);
				  </script>
				  ";
			exit;
		}

		// 파일명에서 확장자 가져옴
		$file_tmp = explode(".", $file_name);
		$ext = @array_pop($file_tmp); // 확장자
		$ext = strtolower($ext); // 확장자를 소문자로 변환

		// 저장할 파일의 전체경로 설정
		$fullname = $savedir . $file_name;

		// 중복파일 체크
		$r = 1;
		while (file_exists($fullname)){
			$file_name = $name . "(" . $r++ . ")" . "." . $ext;
			$fullname = $savedir . $file_name;
		}

		// 파일 업로드 처리
		if (!move_uploaded_file($file, $fullname)){
			echo "<script type='text/javascript'>
			      alert('파일 업로드에 실패하였습니다.');
				  history.go(-1);
				  </script>
				  ";
			exit;
		}
	}

	// 파일명 반환
	return $file_name;
}


//업로드함수 FileUploadName()를 이전 파일 이름을 유지를 위한 변형함수.
function FileUpload_Hold_Name($prev_file, $savedir, $file, $file_name, $prefix = "")
{
	if (!$file_name) return "";

	// 폴더 생성 (20090820 )
	if (!is_dir($savedir)){
		@mkdir($savedir, 0777);
		@chmod($savedir, 0777);
	}

	// 등록파일이 있을 경우 처리 (20090820 )
	if ($file_name){

		// 이전파일 삭제
		if ($prev_file && $prev_file != "no"){
			if (file_exists($savedir . $prev_file)){
				@unlink($savedir . $prev_file);
			}
		}

		// 절대 올리수 없도록 하는 확장자들 체크
		if (preg_match("/\.(php|phps|phtm|htm|html|shtm|ztx|dot|cgi|pl|exe|bat|jsp|asp|inc)$/i", $file_name)){
			echo "<script type='text/javascript'>
			      alert('HTML, PHP 관련파일은 업로드할 수 없습니다.');
				  history.go(-1);
				  </script>
				  ";
			exit;
		}

		// 파일명에서 확장자 가져옴
		$file_tmp = explode(".", $file_name);
		$ext = @array_pop($file_tmp); // 확장자
		$ext = strtolower($ext); // 확장자를 소문자로 변환

		// 저장할 파일의 전체경로 설정
		$fullname = $savedir . $file_name;

		// 중복파일 체크
		$r = 1;
		while (file_exists($fullname)){
			$file_name = $name . "(" . $r++ . ")" . "." . $ext;
			$fullname = $savedir . $file_name;
		}

		// 파일 업로드 처리
		if (!move_uploaded_file($file, $fullname)){
			echo "<script type='text/javascript'>
			      alert('파일 업로드에 실패하였습니다.');
				  history.go(-1);
				  </script>
				  ";
			exit;
		}
	}

	// 파일명 반환
	return $file_name;
}


// 파일명을 인코딩해서 가져옴 (20090820 )
function get_file_encode($filename)
{
	$arr = array();
	if ($filename){
		$arr = array(
			"euckr" => iconv("utf-8", "euc-kr", $filename),
			"utf8" => $filename,
		);
	}

	return $arr;
}

// 임의의 파일명 생성 (20090911 )
function getUniqueFileName($filename, $prefix = "")
{
	if (!$filename) return "";

	// 임의의 문자열 생성
	/*
	$time = date("Ymd"); // 년월일
	$unique = strtoupper(substr(md5(uniqid(time())), 0, 16)); // 유니크 16자리

	// 파일명에서 확장자 가져옴
	$file = explode(".", $filename);
	$ext = @array_pop($file); // 확장자
	$ext = strtolower($ext); // 확장자를 소문자로 변환

	$new_filename = $prefix . $time . "_" . $unique . "." . $ext;
	*/

	$chars_array = array_merge(range(0, 9), range('a', 'z'));

	///
	shuffle($chars_array);
	$shuffle = implode('', $chars_array);
	// 첨부파일 첨부시 첨부파일명에 공백이 포함되어 있으면 일부 PC에서 보이지 않거나 다운로드 되지 않는 현상이 있습니다. (길상여의 님 090925)
	$new_filename = $prefix . abs(ip2long($_SERVER['REMOTE_ADDR'])) . '_' . substr($shuffle, 0, 8) . '_' . replace_filename($filename);


	return $new_filename;
}

// 디렉토리의 파일 리스트를 배열로 반환
if (!function_exists("get_dirlist")){
	function get_dirlist($dir = "./", $mode = "f")
	{
		$arr = array();
		$d = dir($dir);
		while ($entry = $d->read()){
			if ($entry != "." && $entry != ".." && $entry != "Thumbs.db"){
				switch ($mode){
					case "d" :
						if (is_dir("$dir/$entry")) $arr[] = $entry;
						break;
					case "f" :
						if (is_file("$dir/$entry")) $arr[] = $entry;
						break;
					case "l" :
						if (is_link("$dir/$entry")) $arr[] = $entry;
						break;
					default :
						$arr[] = $entry;
				}
			}
		}
		$d->close();
		return $arr;
	}
}


// 제목,내용 ',"" 입력시 처리
function insert_smart($value, $type)
{
	// Quote if not integer
	if ($type == "text"){
		$value = str_replace("\n", "<br>", $value);
		if (!is_numeric($value)){
			$value = mysql_real_escape_string($value);
		}
	}else if ($type == "cate"){
		$value = str_replace('\"', "", $value);
		$value = str_replace("\'", "", $value);
		$value = str_replace("\\", "", $value);
	}else if ($type == "editor"){
		$value = str_replace("'", "''", $value);
		$value = stripslashes($value);
		$value = str_replace("\n\r", "\n", $value);
	}
	return $value;
}

//제목,내용 ',"" 뷰시 처리
function view_smart($value, $type)
{
	// Stripslashes

	if ($type == "text"){
		$value = eregi_replace("<br>", "", $value);
	}

	if (get_magic_quotes_gpc()){
		$value = stripslashes($value);
		$value = str_replace('"', '&#34;', $value);
	}

	return $value;
}

//메일보내기 내용정리
function mail_smart($value)
{
	$value = str_replace("</div>", "</div>\n", $value);
	$value = str_replace("</br>", "</br>\n", $value);
	$value = str_replace("<br />", "<br />\n", $value);
	$value = str_replace("<br>", "<br>\n", $value);
	$value = str_replace("</td>", "</td>\n", $value);
	return $value;
}

//이미지 썸네일 생성
//
//@SaveFile : 원본파일 경로(upload+filename)
//@SaveFileThumb : 썸네일 파일 생성 경로(upload_thum+filename)
//
function make_thum($SaveFile, $SaveFileThumb)
{
	global $cf;

	if (!@is_file($SaveFile)) return false;

	$img_size1 = GetImageSize($SaveFile);
	$img_width1 = $img_size1[0]; //이미지의 넓이를 알 수 있음
	$img_height1 = $img_size1[1]; //이미지의 높이를 알 수 있음

	$src1 = $SaveFile; // 원본
	$dst1 = $SaveFileThumb; // 썸네일

	$quality1 = '100';    // jpg 퀄리티
	$size1 = $cf['thumbnail_size'];        // 줄일 크기 pixel (너비, 또는 높이에 적용)
	//$ratio = '1:1';	// 이미지를 4:3 비율로 잘라냄
	$ratio1 = 'false';    // 원본 이미지비율을 유지

	$get_size1 = _getimagesize($src1, $size1, $ratio1);
	$result1 = resize_image($dst1, $src1, $get_size1, $quality1, $ratio1);

	return $result1;
}

// 변수 또는 배열의 이름과 값을 출력. print_r() 함수의 변형
/* function codeView($var,$flag=false) {
 if($_SERVER['REMOTE_ADDR']=='115.94.73.157'){
 ob_start();
 print_r($var);
 $str = ob_get_contents();
 ob_end_clean();
 echo "<xmp style='font-family:tahoma, 굴림; font-size:12px;'>$str</xmp>";
 if($flag==true) exit;
 }
 } */


//파라미터 변경 함수 박건호 추가(검색 등에서 사용됨)
/*
 $param= "period_s=".$period_s;
 $param.= "&period_str_s=".$period_str_s;

 1. $param2 = re_param($param,'period_str_s=','11');
 -> $param = period_s=&period_str_s=11
 2. $param2 = re_param($param,'period_str_s=','');
 -> $param = period_s=&period_str_s=
 */

function re_param($str, $target, $replace)
{
	if (is_array($target) && is_array($replace)){
		for ($i = 0; $i < count($target); $i++){
			$replace[$i] = $target[$i] . $replace[$i];
			$target[$i] = "/" . $target[$i] . "[^&]*/";
		}
	}else{
		$replace = $target . $replace;
		$target = "/" . $target . "[^&]*/";
	}

	$ref = preg_replace($target, $replace, $str);

	return $ref;
}

/*---------------------------------------------------------------
 @brief : utf8 변경
 @access : public
 @return : string
 ---------------------------------------------------------------*/
if (!function_exists('UTF8')){
	function UTF8($str)
	{
		$str = trim($str);
		if (iconv("UTF-8", "UTF-8", $str) == $str) return $str;
		else return iconv("EUC-KR", "UTF-8", $str);
	}
}

/*---------------------------------------------------------------
 @brief : euckr 변경
 @access : public
 @return : string
 ---------------------------------------------------------------*/
if (!function_exists('EUCKR')){
	function EUCKR($str)
	{
		$str = trim($str);
		if (iconv("EUC-KR", "EUC-KR", $str) == $str) return $str;
		else return iconv("UTF-8", "EUC-KR", $str);
	}
}

/*---------------------------------------------------------------
 @brief : 배열구조 출력
 @access : public
 @return : void
 ---------------------------------------------------------------*/
if (!function_exists('codeView')){
	function codeView($code = '')
	{

		if ($_SERVER['REMOTE_ADDR'] == '220.119.201.99'){
			echo "<pre style='font-family:Tahoma, 굴림; font-size:10pt;'>";
			print_r($code);
			echo '</pre>';
		}
	}
}

/*---------------------------------------------------------------
 @brief : USER-AGENTS
 @parameters :
 @return :
 ---------------------------------------------------------------*/
function check_user_agent($type = NULL)
{
	$user_agent = strtolower($_SERVER['HTTP_USER_AGENT']);
	if ($type == 'bot'){
		// matches popular bots
		if (preg_match("/googlebot|adsbot|yahooseeker|yahoobot|msnbot|watchmouse|pingdom\.com|feedfetcher-google/", $user_agent)){
			return true;
			// watchmouse|pingdom\.com are "uptime services"
		}
	}else if ($type == 'browser'){
		// matches core browser types
		if (preg_match("/mozilla\/|opera\//", $user_agent)){
			return true;
		}
	}else if ($type == 'mobile'){
		// matches popular mobile devices that have small screens and/or touch inputs
		// mobile devices have regional trends; some of these will have varying popularity in Europe, Asia, and America
		// detailed demographics are unknown, and South America, the Pacific Islands, and Africa trends might not be represented, here
		if (preg_match("/phone|iphone|itouch|ipod|symbian|android|htc_|htc-|palmos|blackberry|opera mini|iemobile|windows ce|nokia|fennec|hiptop|kindle|mot |mot-|webos\/|samsung|sonyericsson|^sie-|nintendo/", $user_agent)){
			// these are the most common
			return true;
		}else if (preg_match("/mobile|pda;|avantgo|eudoraweb|minimo|netfront|brew|teleca|lg;|lge |wap;| wap /", $user_agent)){
			// these are less common, and might not be worth checking
			return true;
		}
	}else if ($type == 'iphone'){
		if (preg_match("/phone|iphone|itouch|ipod/", $user_agent)){
			// these are the most common
			return true;
		}
	}
	return false;
}


// 선택페이지일 경우 해당문자열을 출력하는 함수
//
// @param $page : 페이지명 or 게시판코드(BD_CD) (여러개일 경우 '|' 로 구분해서 입력)
// @param $str : 출력할 문자열
// @echo_mode : true일때 echo로 바로찍음, 아닐떈 bloon 값을 리턴. (160609 박건호)
function TO_page_on($page, $str = " class='on'", $echo_mode = true)
{
	$current = current_url();

	if (!$page) return;

	$page_array = @explode("|", $page);
	for ($i = 0; $i < count($page_array); $i++){
		// 페이지명이 같을 경우 출력
		if (strpos($current, $page_array[$i]) !== false){
			if ($echo_mode){
				echo $str;
				return;
			}else{
				return true;
			}
		}

	}


	if (!$echo_mode) return false;
}


//현재폴더명 일치할 경우 문자열 출력
function TO_folder_on($page, $str = "class='on'", $add1 = "")
{
	if (!$page) return;

	$dir = getcwd(); // 현재 디렉토리명을 반환하는 PHP 함수이다.
	$temp = explode("/", $dir);
	$dirname = $temp[sizeof($temp) - 1];

	$page_array = @explode("|", $page);
	for ($i = 0; $i < count($page_array); $i++){
		// 페이지명이 같을 경우 출력
		if ($dirname == str_replace('/', '', $page_array[$i])){
			return $str;
		}
	}
}


//카테고리 on
//str을 리턴
function TO_cate_on($b, $m = "", $s = "", $str = "class='on'")
{
	global $b_uid, $m_uid, $s_uid;

	if (!$b) return "";

	if ($b && $m && $c){
		if ($b == $b_uid && $m == $m_uid && $s == $s_uid) return $str;
	}else if ($b && $m){
		if ($b == $b_uid && $m == $m_uid) return $str;
	}else if ($b){
		if ($b == $b_uid) return $str;
	}

	return "";
}

// 선택페이지일 경우 해당문자열을 출력하는 함수2 (20150414 박건호)
//
// @param $page : 페이지명 (여러개일 경우 '|' 로 구분해서 입력)
// @param $str : 출력할 문자열
// @param $equal : 페이지명이 완전일치할 경우(true), 일부일치(false) (20101105 )
// @return : 없음
// @var 변수명 (20150414)
// @value 변수값 (20150414)
// ex) TO_page_on2('/hotel/list.html','<=$b_uid_s>', '2');   =  리스트파일에서 카테고리번호가 2인것에만 class=on

function TO_page_on2($page, $para = "", $value = "", $str = "class='on'", $equal = false)
{
	if (!$page) return;

	$page_array = @explode("|", $page);
	for ($i = 0; $i < count($page_array); $i++){
		// 게시판코드가 같을 경우 출력
		if ($equal == true){ // 완전일치 (20101105 )
			$filename = basename($_SERVER[PHP_SELF]);
			if (preg_match("/^$filename$/", $page_array[$i])){
				if ($para == $value){
					echo $str;
					return;
				}
			}
		}else{ // 일부일치
			// 페이지명이 같을 경우 출력
			if (strpos($_SERVER[PHP_SELF], $page_array[$i]) !== false){
				if ($para == $value){
					echo $str;
					return;
				}
			}
		}
	}
}


// 자동생성(예약번호 등)
//
function auto_create_code($head = "", $limit = 0)
{
	$str = "";

	$d = date("YmdHi");

	$d = substr($d, 2);

	$random = strtoupper(substr(md5(uniqid(time())), 0, 4));

	$str = $head . $d . "" . $random;

	if ($limit > 0){
		$str = substr($str, 0, $limit);
	}

	return $str;
}





/*
 * 결제관리
 */
function pay_fetch($sql_where = "", $sql_order = "", $sql_limit = "")
{
	global $tb, $cf;

	$table = $tb['pay'];

	//if(!$sql_where) return $array();
	if (!$sql_order) $sql_order = "idx desc ";
	if ($sql_limit) $sql_limit = "limit " . $sql_limit;

	$sql = "select * from {$table} where 1=1 {$sql_where}  order by {$sql_order} {$sql_limit}";
	$result = sql_query($sql);

	$data = sql_fetch_all($result);

	return $data;
}

//결제 변환기
function pay_convert($row)
{

	global $clib;

	$buyer = get_member($row['mb_id']);
	$buyer = $buyer[0];
	$row['mb_name'] = $buyer['mb_name'];

	//과금진행상태
	static $past_data = array();
	if (!count($past_data)) $past_data = $clib->base_codec("PAY", 'PAST', '', '', 'code');

	//결제수단
	static $pamt_data = array();
	if (!count($pamt_data)) $pamt_data = $clib->base_codec("PAY", 'PAMT', '', '', 'code');

	//과금구분(구독)
	static $pagu_data = array();
	if (!count($pagu_data)) $pagu_data = $clib->base_codec("PAY", 'PAGU', '', '', 'code');

	//과금진행상태
	$row['pay_status_nm'] = $past_data[$row['pay_status']]['cd_nm'];

	return $row;
}

//결제로그
function pay_list($sql_where = "", $sql_order = "", $sql_limit = "")
{
	$data = pay_fetch($sql_where, $sql_order, $sql_limit);

	$ref = array();
	foreach ($data as $key => $arr){
		$ref[] = pay_convert($arr);
	}

	return $ref;
}




function kakao_pay_call($fields)
{
	global $cf;

	$headers = array(
		'Authorization: KakaoAK ' . $cf['kakao']['admin_key'],
		'Content-Type: application/x-www-form-urlencoded;charset=utf-8'
	);

	foreach ($fields as $k => $v){
		$fields[$k] = urlencode($v);
	}

	#print_r($fields);

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, 'https://kapi.kakao.com/v1/payment/ready');
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
	curl_setopt($ch, CURLOPT_SAFE_UPLOAD, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);

	$result = curl_exec($ch);
	curl_close($ch);

	//$res = json_decode($result);

	var_dump($result);
}


//다음 주소를 좌표로 반환
function kakao_addr($query='')
{

	$headers = array(
		'Authorization: KakaoAK ' . config_item('kakao_api_key'),
		'Content-Type: application/x-www-form-urlencoded;charset=utf-8'
	);

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, 'https://dapi.kakao.com/v2/local/search/address.json?query='.urlencode($query));
	curl_setopt($ch, CURLOPT_POST, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
	curl_setopt($ch, CURLOPT_SAFE_UPLOAD, true);
	//curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);

	$result = curl_exec($ch);
	curl_close($ch);

	$datas = json_decode($result, true);



	$ref = array();
	if(isset($datas['errorType'])){
		$ref['error'] = true;
		$ref['errorType'] = $datas['errorType'];
		$ref['message'] = $datas['message'];
		$ref['datas'] = array();
	}else{
		$ref['error'] = false;
		$ref['datas'] = $datas['documents']['0']['address'];
	}

	return $ref;
}


// 변수 또는 배열의 이름과 값을 얻어냄. print_r() 함수의 변형
function print_r2($var)
{

	ob_start();
	print_r($var);
	$str = ob_get_contents();
	ob_end_clean();
	$str = str_replace(" ", "&nbsp;", $str);
	echo nl2br("<span style='font-family:Tahoma, 굴림; font-size:9pt;'>$str</span>");

}


function TO_number($price)
{
	return str_replace(",", "", $price);
}

function get_number($str)
{
	return preg_replace("/[^0-9\-]/i", "", $str);
}


function conv_date($date, $format = 1, $lang = "korean")
{


	if (!preg_match("/[^0-9]/", $date)) $date = date("Y-m-d H:i:s", strtotime($date));
	$yoil = "(" . get_yoil($date, $lang) . ")";
	$date_array = explode(" ", $date);

	switch ($format){
		case 1 :
			$str = $date_array[0] . $yoil;
			break;
		case 2 :
			$str = $date_array[0] . $yoil . " " . $date_array[1];
			break;
		case 3 :
			list($yy, $mm, $dd) = explode("-", $date_array[0]);
			$str = $yy . "년 " . $mm . "월 " . $dd . "일" . $yoil . " " . $date_array[1];
			break;
		case 4 :
			list($yy, $mm, $dd) = explode("-", $date_array[0]);
			list($hh, $ii, $ss) = explode(":", $date_array[1]);
			$str = $yy . "년 " . $mm . "월 " . $dd . "일" . $yoil;
			$str .= $hh . "시 " . $ii . "분 " . $ss . "초";
			break;

		case 5 :
			list($yy, $mm, $dd) = explode("-", $date_array[0]);
			$str = $yy . "." . $mm . "." . $dd;
			break;

		case 6 :

			list($yy, $mm, $dd) = explode("-", $date_array[0]);
			$str = $yy . "년 " . $mm . "월 " . $dd . "일";
			break;

		case 7 :
			list($yy, $mm, $dd) = explode("-", $date_array[0]);
			$str = sprintf('%2d', $mm) . "월 " . sprintf('%2d', $dd) . "일";
			break;

		case 8 :
			list($yy, $mm, $dd) = explode("-", $date_array[0]);
			$str = sprintf('%d', $mm) . "/" . sprintf('%d', $dd);
			break;
		case 9 :
			//list($hh, $ii, $ss) = explode(":", $date_array[1]);
			//$str = sprintf('%d', $ii)."분".sprintf('%d', $ss)."초";
			$time = strtotime($date);
			$str = seconds2human2($time);

			break;

		case 10 :
			list($yy, $mm, $dd) = explode("-", $date_array[0]);
			$str = sprintf('%d', $mm) . "월 " . sprintf('%d', $dd) . "일";
			list($hh, $ii, $ss) = explode(":", $date_array[1]);
			$str .= " " . $hh . ":" . $ii;
			break;

		case 11 :
			list($yy, $mm, $dd) = explode("-", $date_array[0]);
			$str = substr($yy, 2, 2) . "년" . sprintf('%2d', $mm) . "월";
			break;


		case 12 :
			list($yy, $mm, $dd) = explode("-", $date_array[0]);
			$str = sprintf('%d', $mm) . "월 " . sprintf('%d', $dd) . "일";
			break;

		case 13 :

			list($yy, $mm, $dd) = explode("-", $date_array[0]);
			$str = substr($yy, 2, 2) . "년" . $mm . "월" . $dd . "일";
			break;

        case 20 :
            list($yy, $mm, $dd) = explode("-", $date_array[0]);
            $str = substr($yy, 2, 2) . "." . $mm . "." . $dd;
            break;

        case 21 :
            list($yy, $mm, $dd) = explode("-", $date_array[0]);
            $str = substr($yy, 2, 2) . "." . $mm . "." . $dd;

            list($hh, $ii, $ss) = explode(":", $date_array[1]);
            $str .= " " . $hh . ":" . $ii;

            break;
	}

	return $str;
}


// 요일 반환
function get_yoil($date, $lang = "korean", $opt = "")
{
	$yoil = array(
		'korean' => array('일', '월', '화', '수', '목', '금', '토'),
		'chinese' => array('日', '月', '火', '水', '木', '金', '土'),
		'english' => array('SUN', 'MON', 'TUE', 'WED', 'THU', 'FRI', 'SAT')
	);

	$yoil_num = date("w", strtotime($date)); // 'w' 숫자반환 : 0(일)~6(토)
	$str = $yoil[$lang][$yoil_num];

	if ($opt == "w") $str = $yoil_num;// 'w' 숫자반환

	return $str;
}


//가상번호 자르기
function get_vphone($phone, $hyphen = 1)
{
	if (strlen($phone) != 12){
		return '';
	}
	if ($hyphen){
		$preg = "$1-$2-$3";
	}else{
		$preg = "$1$2$3";
	}

	$phone = str_replace('-', '', trim($phone));
	$phone = preg_replace(
		"/^([0-9]{4})([0-9]{4})([0-9]{4})$/",
		$preg,
		$phone
	);
	return $phone;
}


// 문자열(한글) 자르기 (UTF-8) (20091022 )
function cut_str_utf($str, $size, $tail = "...")
{
	$substr = substr($str, 0, $size * 2);
	$multi_size = preg_match_all('/[\x80-\xff]/', $substr, $multi_chars);

	if ($multi_size > 0) $size = $size + intval($multi_size / 3) - 1;

	if (strlen($str) > $size){
		$str = substr($str, 0, $size);
		$str = preg_replace('/(([\x80-\xff]{3})*?)([\x80-\xff]{0,2})$/', '$1', $str);
		$str .= $tail;
	}

	return $str;
}

function file_extension($filename, $add_dot = true)
	{
		$x = explode('.', $filename);

		if (count($x) === 1)
		{
			return '';
		}

		$ext = strtolower(end($x));
		if($add_dot) $ext = '.'.$ext;

		return $ext;
	}


function set_null($value = '', $force_null = FALSE)
{
	if ($force_null == TRUE)
	{
		return NULL;
	}
	return $value == '' ? NULL : $value;
}



//두날짜간에 일수 차이(20130515)
function date_diff2($date1 , $date2)
{
	$diff = 0;

	if($date1==$date2) return $diff;

	$date2_arr = explode("-",$date2);
	$date1_arr = explode("-",$date1);

	$tmp1 = mktime(0,0,0,$date2_arr[1],$date2_arr[2],$date2_arr[0]);
	$tmp2 = mktime(0,0,0,$date1_arr[1],$date1_arr[2],$date1_arr[0]);

	if($tmp1 > $tmp2) $diff = ($tmp1-$tmp2)/86400;
	else $diff = ($tmp2-$tmp1)/86400;

	return $diff;
}

//두날짜 사이에 일수 모두구해서 리턴(20130515)
function date_to_date($date1 , $date2 ,$lastdate_yn="Y")
{
	$data = array();

	if($date1 > $date2) return $data;

	$cnt = date_diff2($date1 , $date2);

	if($lastdate_yn=="N") $cnt=--$cnt;//@date2 당일은 제외

	for($i=0 ; $i<=$cnt ; $i++){
		$date = date("Y-m-d",strtotime($date1." +".$i." day"));
		$data[$i]['date'] = $date;
		$data[$i]['yoil'] = get_yoil($date);
		$data[$i]['yoil_ord'] = get_yoil($date,"","w");
	}

	/*if ($cnt==0) {
			$date = date("Y-m-d");
			$data[0]['date'] = $date;
			$data[0]['yoil'] = get_yoil($date);
			$data[0]['yoil_ord'] = get_yoil($date,"","w");
	}*/

	return $data;
}


function read_korean($num)
{
	$return_val = "";
	if(!is_numeric($num))
	{
		//echo("<script>window.alert('유효한 숫자가 아닙니다')</script>");
		return 0;
	}

	$arr_number = strrev($num);

	for($i =strlen($arr_number)-1; $i>=0; $i--)
	{
		/////////////////////////////////////////////////
		// 현재 자리를 구함
		$digit = substr($arr_number, $i, 1);
		///////////////////////////////////////////////////////////
		// 각 자리 명칭
		switch($digit)
		{
			case '-' : $return_val .= "(-) ";
				break;
			case '0' : $return_val .= "";
				break;
			case '1' : $return_val .= "일";
				break;
			case '2' : $return_val .= "이";
				break;
			case '3' : $return_val .= "삼";
				break;
			case '4' : $return_val .= "사";
				break;
			case '5' : $return_val .= "오";
				break;
			case '6' : $return_val .= "육";
				break;
			case '7' : $return_val .= "칠";
				break;
			case '8' : $return_val .= "팔";
				break;
			case '9' : $return_val .= "구";
				break;
		}

		if($digit=="-")continue;

		///////////////////////////////////////////////////////////
		// 4자리 표기법 공통부분
		if($digit != 0)
		{
			if($i % 4 == 1)$return_val .= "십";
			else if($i % 4 == 2)$return_val .= "백";
			else if($i % 4 == 3)$return_val .= "천";
		}

		///////////////////////////////////////////////////////////
		// 4자리 한자 표기법 단위
		if($i % 4 == 0)
		{
			if( floor($i/ 4) ==0)$return_val .= "";
			else if(floor($i / 4)==1)$return_val .= "만";
			else if(floor($i / 4)==2)$return_val .= "억";
			else if(floor($i / 4)==3)$return_val .= "조";
			else if(floor($i / 4)==4)$return_val .= "경";
			else if(floor($i / 4)==5)$return_val .= "해";
			else if(floor($i / 4)==6)$return_val .= "자";
			else if(floor($i / 4)==7)$return_val .= "양";
			else if(floor($i / 4)==8)$return_val .= "구";
			else if(floor($i / 4)==9)$return_val .= "간";
			else if(floor($i / 4)==10)$return_val .= "정";
			else if(floor($i / 4)==11)$return_val .= "재";
			else if(floor($i / 4)==12)$return_val .= "극";
			else if(floor($i / 4)==13)$return_val .= "항하사";
			else if(floor($i / 4)==14)$return_val .= "아승기";
			else if(floor($i / 4)==15)$return_val .= "나유타";
			else if(floor($i / 4)==16)$return_val .= "불가사의";
			else if(floor($i / 4)==16)$return_val .= "무량대수";    }
	}

	return $return_val;
}

?>
