<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="ko">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title; ?></title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            padding: 20px;
        }
        .container {
            max-width: 800px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
        }
        .alert {
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="mb-4"><?php echo $title; ?></h1>
        
        <ul class="nav nav-tabs mb-4">
            <li class="nav-item">
                <a class="nav-link" href="<?php echo site_url('push_admin/individual'); ?>">개별 알림</a>
            </li>
            <li class="nav-item">
                <a class="nav-link active" href="<?php echo site_url('push_admin/broadcast'); ?>">전체 알림</a>
            </li>
        </ul>
        
        <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if (isset($success)): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <?php echo form_open('push_admin/broadcast', 'class="needs-validation" novalidate'); ?>
            <div class="form-group">
                <label for="user_type">사용자 유형 *</label>
                <select class="form-control" id="user_type" name="user_type" required>
                    <option value="">선택하세요</option>
                    <option value="engineer" <?php echo set_select('user_type', 'engineer'); ?>>기사</option>
                    <option value="company" <?php echo set_select('user_type', 'company'); ?>>공장</option>
                    <option value="all" <?php echo set_select('user_type', 'all'); ?>>전체</option>
                </select>
                <?php echo form_error('user_type', '<div class="text-danger">', '</div>'); ?>
            </div>
            
            <div class="form-group">
                <label for="title">제목 *</label>
                <input type="text" class="form-control" id="title" name="title" value="<?php echo set_value('title'); ?>" required>
                <?php echo form_error('title', '<div class="text-danger">', '</div>'); ?>
            </div>
            
            <div class="form-group">
                <label for="message">내용 *</label>
                <textarea class="form-control" id="message" name="message" rows="5" required><?php echo set_value('message'); ?></textarea>
                <?php echo form_error('message', '<div class="text-danger">', '</div>'); ?>
            </div>
            
            <div class="form-group">
                <label for="image_url">이미지 URL</label>
                <input type="url" class="form-control" id="image_url" name="image_url" value="<?php echo set_value('image_url'); ?>">
                <small class="form-text text-muted">알림에 표시할 이미지의 URL을 입력하세요. (선택사항)</small>
            </div>
            
            <div class="form-group">
                <label for="click_action">이동 URL</label>
                <input type="url" class="form-control" id="click_action" name="click_action" value="<?php echo set_value('click_action'); ?>">
                <small class="form-text text-muted">알림 클릭 시 이동할 URL을 입력하세요. (선택사항)</small>
            </div>
            
            <button type="submit" class="btn btn-primary">알림 전송</button>
        <?php echo form_close(); ?>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        // 폼 유효성 검사
        (function() {
            'use strict';
            window.addEventListener('load', function() {
                var forms = document.getElementsByClassName('needs-validation');
                var validation = Array.prototype.filter.call(forms, function(form) {
                    form.addEventListener('submit', function(event) {
                        if (form.checkValidity() === false) {
                            event.preventDefault();
                            event.stopPropagation();
                        }
                        form.classList.add('was-validated');
                    }, false);
                });
            }, false);
        })();
    </script>
</body>
</html> 